"use-client";

import React from 'react';
import Checkbox from '@mui/material/Checkbox';
import TableCell from '@mui/material/TableCell';
import { useTheme } from '@mui/material/styles';
import SvgColor from '@/shared/components/svg-color';
import { TableColumn } from '@/shared/types/common';
import { ContratStyledRow, getStatusColor } from '@/shared/sections/contract/styles';
import { ISubmittedRoadmap, SubmittedRoadMapStatus } from '@/shared/types/driver';
import { Button, IconButton } from '@mui/material';
import CustomTooltip from '@/shared/components/tooltips/tooltip-custom';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import {faEdit, faPen} from '@fortawesome/free-solid-svg-icons';
import { faRocketchat } from '@fortawesome/free-brands-svg-icons';
import { ActionsIconButton } from '@/shared/theme/css';
import FontAwesome from '@/shared/components/fontawesome';
import ConditionalComponent from '@/shared/components/table/ConditionalComponent';
import { SubmittedRoadMapDTO } from '@/shared/types/roadMap';

type Props = {
  handleEdit: (roadmap: SubmittedRoadMapDTO) => void;
  handleDetails: (roadmap: SubmittedRoadMapDTO) => void;
  handleCopy: (roadmap: SubmittedRoadMapDTO) => void;
  selected: boolean;
  dense: boolean;
  row: SubmittedRoadMapDTO;
  onSelectRow: VoidFunction;
  columns: TableColumn[];
  onClickOldRoadMaps: (roadmap: SubmittedRoadMapDTO) => void;
  onClickContact: (roadmap: SubmittedRoadMapDTO) => void;
};

export default function SubmittedRoaMapTableRow({
  row,
  handleEdit,
  handleDetails,
  handleCopy,
  selected,
  dense,
  onSelectRow,
  columns,
  onClickOldRoadMaps,
  onClickContact,
}: Props) {
  const theme = useTheme();
  const isActive = true;
  

  const renderCellContent = (column: any, value: any) => {
    switch (column.id) {
      case 'isSubmitted':
        return (
          <Button
            size="small"
            sx={{
              borderRadius: 2.5,
              textTransform: 'capitalize',
              backgroundColor:
                row.isSubmitted ? '#E9FBF0' : '#FFE1E1',
              color: row.isSubmitted ? '#36B37E' : '#FF3434',
            }}
          >
            {row.isSubmitted ? 'Soumise' : 'Non soumise'}
          </Button>
        );
      default:
        return value;
    }
  };

  

  return (
    <ContratStyledRow hover style={{ cursor: 'pointer' }}>
      {columns.map((column: any, index: number) => (
        <TableCell
          key={column.id}
          sx={{ whiteSpace: 'nowrap',
            ...(index === 0 && {
              position: 'relative',
            }),
            py: column.id === 'isSubmitted' ? 0 : dense ? 0 : 2.3 
          }}
        >
            <ConditionalComponent isValid={index === 0}>
            <SvgColor
              src="/assets/icons/ic_border.svg"
              sx={{ position: 'absolute', top: 0, left: -4, height: '100%', color: getStatusColor(row.isSubmitted ? '#22c55e' : '#81919A'),
              }}
            />
          </ConditionalComponent>
          {renderCellContent(column, row[column.id as keyof SubmittedRoadMapDTO])}
        </TableCell>
      ))}
      <TableCell sx={{ px: 1, whiteSpace: 'nowrap', py: 0 }}>
        <CustomTooltip title="Contacter" arrow>
        <IconButton
            sx={{ py: 0, px: 0.5 }}
            onClick={(e) => {
              e.stopPropagation(); 
              onClickContact(row); 
            }}
          >
            <FontAwesomeIcon icon={faRocketchat} width={16} />
          </IconButton>
        </CustomTooltip>
      </TableCell>
      <TableCell sx={{ px: 1, whiteSpace: 'nowrap', py: 0 }}>
      <CustomTooltip title="Consulter l'historique" arrow>
          <IconButton sx={{ py: 0, px: 0.5 }} onClick={(e) => {
            e.stopPropagation();
            onClickOldRoadMaps(row);
          }}>
            <SvgColor
              src="/assets/icons/navbar/ic_table.svg"
              sx={{ width: 16 }}
            />
          </IconButton>
        </CustomTooltip>

        <CustomTooltip title="Saisir une feuille" arrow>
          <IconButton
            sx={{ py: 0, px: 0.5 }}
            onClick={() => handleDetails(row)}
            disabled={row.isSubmitted}
          >
            <FontAwesomeIcon icon={faEdit} width={16} />
          </IconButton>
        </CustomTooltip>
      </TableCell>
    </ContratStyledRow>
  );
}
