"use client"
import { useState } from "react"
import Checkbox from "@mui/material/Checkbox"
import TableCell from "@mui/material/TableCell"
import { useTheme } from "@mui/material/styles"
import type { TableColumn } from "@/shared/types/common"
import { StatusChip } from "@/shared/sections/contract/styles"
import { dateFormat, formatDate } from "@/utils/format-time"
import { getTrajetPret } from "@/shared/_mock/_circuitTrajets"
import type { IcircuitTrajet } from "@/shared/types/circuit"
import { TrajetStyledRow } from "@/shared/sections/contract/styles"
import { getEtatLabel } from "@/shared/_mock/_circuit"
import CustomTooltip from "@/shared/components/tooltips/tooltip-custom"
import { IconButton, List, ListItem, ListItemIcon, ListItemText } from "@mui/material"
import FontAwesome from "@/shared/components/fontawesome"
import { faArrowUpRightFromSquare, faEye } from "@fortawesome/free-solid-svg-icons"
import { ActionsIconButton } from "@/shared/theme/css"
import { useRouter } from "@/hooks/use-router"
import { paths } from "@/routes/paths"
import UsagerDetailsDialog from "./usager-details-dialog"

type Props = {
  handleEditContract: (contrat: IcircuitTrajet) => void
  handleDetailsContract: (contrat: IcircuitTrajet) => void
  selected: boolean
  row: IcircuitTrajet
  dense: boolean
  onSelectRow: VoidFunction
  columns: TableColumn[]
}

export default function TrajetTableRow({
  dense,
  row,
  handleEditContract,
  handleDetailsContract,
  selected,
  onSelectRow,
  columns,
}: Props) {
  const theme = useTheme()
  const router = useRouter()
  const [openDialog, setOpenDialog] = useState(false)
  const [selectedUsager, setSelectedUsager] = useState<string | null>(null)

  const openTrajetPage = (id: string) => {
    router.push(`${paths.dashboard.exploitation.circuitUsager.trajet}?id=${id}`)
  }

  const handleOpenUsagerDetails = (usager: string) => {
    setSelectedUsager(usager)
    setOpenDialog(true)
  }

  const handleCloseDialog = () => {
    setOpenDialog(false)
    setSelectedUsager(null)
  }

  const renderCellContent = (columnId: string, value: any) => {
    switch (columnId) {
      case "dateDebut":
        return formatDate(value, dateFormat.isoDate)
      case "etat":
        return <StatusChip label={getEtatLabel(value)} status={value} theme={theme} size="small" />
      case "preparation":
        return <StatusChip label={getTrajetPret(value)} status={value} theme={theme} size="small" />
      case "usagers":
        return (
          <List dense sx={{ p: 0 }}>
            {Array.isArray(value) &&
              value.map((usager, index) => (
                <ListItem key={index} sx={{ p: 0, mb: index < value.length - 1 ? 0.5 : 0 }}>
                  <ListItemText primary={usager} sx={{ m: 0 }} />
                  <ListItemIcon sx={{ minWidth: "auto", ml: 1 }}>
                    <CustomTooltip title={"Détails usager"}>
                      <IconButton onClick={() => handleOpenUsagerDetails(usager)} size="small">
                        <FontAwesome icon={faEye} width={14} />
                      </IconButton>
                    </CustomTooltip>
                  </ListItemIcon>
                </ListItem>
              ))}
          </List>
        )
      default:
        return value
    }
  }

  return (
    <>
      <TrajetStyledRow  style={{ cursor: "pointer" }}>
        {columns.slice(0, -1).map((column: any) => (
          <TableCell
            onDoubleClick={() => handleDetailsContract(row)}
            key={column.id}
            align={column.align || "left"}
            sx={{ whiteSpace: "nowrap", py: column.id === "etat" ? 0.2 : dense ? 0.5 : 1 }}
          >
            {renderCellContent(column.id, row[column.id as keyof IcircuitTrajet])}
          </TableCell>
        ))}
        <TableCell align="center">
          <CustomTooltip title={"Consulter trajet"} arrow>
            <IconButton onClick={() => openTrajetPage(row.numeroTrajet)} size="small" sx={ActionsIconButton}>
              <FontAwesome icon={faArrowUpRightFromSquare} width={14} />
            </IconButton>
          </CustomTooltip>
        </TableCell>
      </TrajetStyledRow>

      <UsagerDetailsDialog open={openDialog} onClose={handleCloseDialog} usager={selectedUsager} />
    </>
  )
}
