import { TabConfig, useTabsManager } from '@/hooks/use-tabs-manager';
import { AddressType, EstablishmentSector, EstablishmentTableItem, EstablishmentType, EstablishmentRequest } from '@/shared/types/establishment';

const initialValues: EstablishmentTableItem = {
  id: '',
  establishmentName: '',
  address: {
    street: '',
    city: '',
    country: '',
    zipCode: '',
    latitude: 0,
    longitude: 0,
    addressType: AddressType.ESTABLISHMENT,
  },
  establishmentSector: EstablishmentSector.PRIVATE,
  uaiCode: '',
  hours: [],
  phoneNumber: '',
  establishmentType: EstablishmentType.PRIMARY_SCHOOL,
  departmentName: '',
  active: true,
};

const establishmentConfig: TabConfig<EstablishmentTableItem | EstablishmentRequest> = {
  type: 'establishment',
  listTitle: 'Liste des établissements',
  newItemTitle: 'Nouveau établissement',
  initialData: initialValues,
  getItemCode: (establishment) => establishment.establishmentName,
};

export function useEstablishmentTabs() {
  return useTabsManager<EstablishmentTableItem | EstablishmentRequest>(establishmentConfig);
}