import * as Yup from 'yup';
import { EstablishmentSector, EstablishmentType } from '@/shared/types/establishment';

export const establishmentSchema = Yup.object().shape({
  establishmentName: Yup.string().required('Le nom de l\'établissement est requis'),
  establishmentCode: Yup.string().required('Le code de l\'établissement est requis'),
  uaiCode: Yup.string().required('Le code UAI est requis'),
  establishmentSector: Yup.string().oneOf(Object.values(EstablishmentSector)).required('Le régime est requis'),
  establishmentType: Yup.string().oneOf(Object.values(EstablishmentType)).required('Le type d\'établissement est requis'),
  mondayMorningOpeningTime: Yup.string(),
  mondayEveningClosingTime: Yup.string(),
  tuesdayMorningOpeningTime: Yup.string(),
  tuesdayEveningClosingTime: Yup.string(),
  wednesdayMorningOpeningTime: Yup.string(),
  wednesdayEveningClosingTime: Yup.string(),
  thursdayMorningOpeningTime: Yup.string(),
  thursdayEveningClosingTime: Yup.string(),
  fridayMorningOpeningTime: Yup.string(),
  fridayEveningClosingTime: Yup.string(),
  saturdayMorningOpeningTime: Yup.string(),
  saturdayEveningClosingTime: Yup.string(),
  sundayMorningOpeningTime: Yup.string(),
  sundayEveningClosingTime: Yup.string(),
  mapAddress: Yup.object().shape({
    address: Yup.string().required('L\'adresse est requise'),
    lat: Yup.number(),
    lng: Yup.number(),
    placeId: Yup.string(),
    formattedAddress: Yup.string(),
    city: Yup.string(),
    postalCode: Yup.string(),
    country: Yup.string(),
  }),
  phoneNumber: Yup.string().required('Le numéro de téléphone est requis'),
  colorCode: Yup.string().required('Le code couleur est requis'),
  fax: Yup.string().required('Le numéro de fax est requis'),
  email: Yup.string().email('Email invalide').required('L\'email est requis'),
  website: Yup.string().url('URL invalide'),
  doId: Yup.string(),
  doCode: Yup.string(),
  departmentId: Yup.string().required('Le département est requis'),
  zoneId: Yup.string().required('La zone scolaire est requis'),
  establishmentManager: Yup.object().shape({
    civility: Yup.string().required('La civilité est requise'),
    firstName: Yup.string().required('Le prénom est requis'),
    lastName: Yup.string().required('Le nom est requis'),
    phoneNumber: Yup.string().required('Le numéro de téléphone est requis'),
    personalEmail: Yup.string().email('Email invalide').required('L\'email est requis'),
  }).required('Les informations du responsable sont requises'),
  observation: Yup.string(),
  academy: Yup.string().required('L\'académie est requise'),
  active: Yup.boolean(),
});