import * as yup from 'yup'
import { FuelType } from '@/shared/types/flottes/fuelFee'

export const fuelFeeSchema = yup.object().shape({
  vehicule: yup.string().required('Le véhicule est requis'),
  chauffeur: yup.string().required('Le chauffeur est requis'),
  date: yup.date().required('La date est requise'),
  type: yup.string().oneOf(Object.values(FuelType), 'Type de carburant invalide').required('Le type est requis'),
  departement: yup.string().required('Le département est requis'),
  kmCompteur: yup.number().required('Le kilométrage est requis'),
  kmParcourue: yup.number().required('Les kilomètres parcourus sont requis'),
  volumeCarburant: yup.number().required('Le volume de carburant est requis'),
  prix: yup.number().required('Le prix est requis'),
  total: yup.number(),
  observation: yup.string(),
}) 