'use client';

import React, { useState } from 'react';
import { Box, Button, Grid, Stack, Typography } from '@mui/material';
import { FormFieldType, TypeImport } from '@/shared/types/common';
import { AddButton, mainColor } from '@/shared/components/table/styles';
import FontAwesome from '@/shared/components/fontawesome';
import { faFileArrowUp } from '@fortawesome/free-solid-svg-icons';
import { fuelImportformFields } from '../utils/form-fields-fuel-import';
import FormField from '@/shared/components/form/form-field';
import { IFuelImport, INITIAL_FUEL_IMPORT_DATA } from '@/shared/types/flottes/fuelImport';
import FormContainer from '@/layouts/form/form-container';
import { useBoolean } from '@/hooks';
import MassUploadFile from '@/shared/components/mass-import/mass-upload-file';
import FuelFeeListView from './fuel-card-list-view';
import { HEADER } from '@/layouts/config-layout';
import { ScrollBox } from '@/shared/theme/css';
import { pxToRem } from '@/shared/theme/typography';

export default function FuelImportListView() {
  const [formData, setFormData] = useState<IFuelImport>(INITIAL_FUEL_IMPORT_DATA);
  const uploadFile = useBoolean(false);

  const renderField = (field: FormFieldType<IFuelImport>) => (
    <FormField
      field={field}
      value={formData[field.name]}
      onChange={(name, value) => setFormData((prev) => ({ ...prev, [name]: value }))}
      isReadOnly={false}
    />
  );
  return (
    <ScrollBox
      sx={{
        borderTopLeftRadius: '10px',
        mb: 0.5,
        backgroundColor: 'white',
        pb: 1,
        pt: 2,
        px: 6,
        height: `calc(100vh - ${HEADER.H_DESKTOP + 20}px)`,
      }}
    >
      <Typography
        sx={{
          mb: 3,
          fontSize: pxToRem(30),
          color: 'primary.main',
          fontWeight: (theme) => theme.typography.fontWeightBold,
        }}
      >
        {'Importer des cartes carburant'}
      </Typography>

          <form>
          <Grid container spacing={4}>
              {fuelImportformFields.map((field) => (
              <Grid item xs={12} sm={4} key={field.name}>
                  {renderField(field)}
                </Grid>
              ))}
             <Grid item xs={12} sm={6} xl={4} key={"import"} sx={{ display: 'flex' }}>
            
                <Typography
                  sx={{
                    color: 'primary.main',
                    display: { sm: 'none', md: 'block' },
                    m: 'auto' 
                  }}
                >
                  Fichier du pétrolier
                </Typography>
                <AddButton
                  variant="contained"
                  onClick={uploadFile.onTrue}
                  sx={{ minHeight: '43px' }}
                  endIcon={<FontAwesome icon={faFileArrowUp} width={18} />}
                >
                  Importez un document
                </AddButton>
                </Grid>
          </Grid>
          <Grid item xs={12} sx={{display:'flex',justifyContent:'flex-end'}}>
                <Button
                  variant="contained"
                  onClick={void 0}
                  sx={{
                    boxShadow: 'none',
                    textTransform: 'none',
                    ...mainColor,
                  }}
                >
                  Valider
                </Button>
              </Grid>
            
          </form>
        
      <FuelFeeListView></FuelFeeListView>

      {uploadFile.value ? (
        <MassUploadFile
          open={uploadFile.value}
          onClose={uploadFile.onFalse}
          type={TypeImport.FUEL}
        />
      ) : (
        <></>
      )}
    </ScrollBox>
  );
}
