"use client"
import Checkbox from "@mui/material/Checkbox"
import TableCell from "@mui/material/TableCell"
import SvgColor from "@/shared/components/svg-color"
import type { TableColumn } from "@/shared/types/common"
import { ContratStyledRow, getStatusColor, StatusChip } from "@/shared/sections/contract/styles"
import { dateFormat, formatDate } from "@/utils/format-time"
import { Consumption} from "@/shared/types/flottes/consumption"
import { useTheme } from '@mui/material/styles';
import ConditionalComponent from "@/shared/components/table/ConditionalComponent"

type Props = {
  selected: boolean
  row: Consumption
  onSelectRow: VoidFunction
  columns: TableColumn[]
  onRowDoubleClick: () => void
  dense?:boolean
  }

export default function AllConsumptionsTableRow({
  row,
  selected,
  onSelectRow,
  columns,
  onRowDoubleClick,
  dense
}: Props) {
  const theme = useTheme();

  const renderCellContent = (column: Consumption, value: any) => {
    switch (column.id) {
      case "employe":
        return `${row.employe.firstName} ${row.employe.lastName}`
      case "date":
        return formatDate(value, dateFormat.isoDate)
      case "department":
        return row.employe.department
      case "statut": 
        return  <StatusChip label={row.normalConsumption ? 'Normal' : 'Anormal'} status={row.normalConsumption ? 'oui' : 'non'} theme={theme} size="small" />
    default:
        return value
    }
  }
  return (
    <>
      <ContratStyledRow hover style={{ cursor: "pointer" }}>
        {columns.map((column: any, index: number) => (
          <TableCell
            onDoubleClick={onRowDoubleClick}
            key={column.id}
            align={column.align}
            sx={{ whiteSpace: "nowrap", py: dense ? 0 : 1, ...(index === 0 && {position: "relative"}), }}
          >
            <ConditionalComponent isValid={index === 0}>
            <SvgColor
                src="/assets/icons/ic_border.svg"
                sx={{ position: "absolute", top: 0, left: -4, height: "100%", color: getStatusColor(row.city) }}
              />
            </ConditionalComponent>
            {renderCellContent(column, row[column.id as keyof Consumption])}
          </TableCell>
        ))}
      </ContratStyledRow>
    </>
  )
}

