import { TabConfig, useTabsManager } from '@/hooks/use-tabs-manager';
import { INITIAL_ABSENCE_DATA } from '@/shared/_mock/_rhAbsence';
import { IRHAbsence } from '../../../../types/absence-rh';

const absenceUsagerConfig: TabConfig<IRHAbsence> = {
  type: 'absence-rh',
  listTitle: 'Liste absence',
  newItemTitle: 'Nouveau absence',
  initialData: INITIAL_ABSENCE_DATA,
  getItemCode: (absence) => absence.numeroEnregistrement || `ABS-${absence.id}`,
};

export function useAbsenceUsagerTabs() {
  return useTabsManager<IRHAbsence>(absenceUsagerConfig);
} 