import * as Yup from 'yup';

export const absenceSchema = Yup.object().shape({
  nomChauffeur: Yup.string().required('Le nom du chauffeur est obligatoire'),
  type: Yup.string().required('Le type est obligatoire'),
  typeAbsence: Yup.string().required('Le type d\'absence est obligatoire'),
  dateDebut: Yup.date().required('La date de début est obligatoire'),
  dateFin: Yup.date()
    .required('La date de fin est obligatoire')
    .min(Yup.ref('dateDebut'), 'La date de fin doit être postérieure à la date de début'),
  modeReception: Yup.string().required('Le mode de réception est obligatoire'),
  justificatif: Yup.string().nullable(),
  affecteTrajet: Yup.string().nullable(),
  statut: Yup.string().required('Le statut est obligatoire'),
  nbrHeures: Yup.number()
    .required('Le nombre d\'heures est obligatoire')
    .min(0, 'Le nombre d\'heures doit être positif'),
  autorisePar: Yup.string().nullable(),
  validerPar: Yup.string().nullable(),
  departement: Yup.string().nullable(),
}); 