import { TabConfig, useTabsManager } from '@/hooks/use-tabs-manager';
import { INITIAL_LEAVE_DATA } from '@/shared/_mock/_conge';
import { ILeave } from '@/shared/types/leave';

const congeConfig: TabConfig<ILeave> = {
  type: 'conge',
  listTitle: 'Liste des congés',
  newItemTitle: 'Nouveau congé',
  initialData: INITIAL_LEAVE_DATA,
  getItemCode: (conge: ILeave) => `${conge.employeeName} - ${conge.leaveType}`,
};

export function useCongeTabs() {
  const tabManager = useTabsManager<ILeave>(congeConfig);

  const handleApprove = async (conge: ILeave) => {
    const updatedConge = {
      ...conge,
      statut: 'approuve' as const,
      decision: 'validee' as const,
      dateTraitement: new Date().toISOString(),
    };
    return updatedConge;
  };

  const handleReject = async (conge: ILeave) => {
    const updatedConge = {
      ...conge,
      statut: 'refuse' as const,
      decision: 'refusee' as const,
      dateTraitement: new Date().toISOString(),
    };
    return updatedConge;
  };

  const handleViewHistory = (conge: ILeave) => {
  };

  const handleDelete = async (conge: ILeave) => {
  };

  return {
    ...tabManager,
    handleApprove,
    handleReject,
    handleViewHistory,
    handleDelete,
  };
}