import { _documentsRh } from "@/shared/_mock/_documentsRh";
import { FormFieldType } from "@/shared/types/common";
import { PrioriteDemande } from "@/shared/types/demande";
import { Document } from "@/shared/types/document";
import {
    faFileLines,
    faCalendar,
    faUser,
    faTag,
    faFileCircleCheck,
    faListCheck,
} from '@fortawesome/free-solid-svg-icons';

export const documentformfeilds: FormFieldType<Document>[] = [
    {
        name: 'name',
        label: 'Nom du document',
        type: 'text',
        required: true,
        icon: faFileLines,
    },
    {
        name: 'status',
        label: 'Statut',
        type: 'select',
        options: [
            { value: 'non traité', label: 'Non traité' },
            { value: 'traité', label: 'Traité' },
            { value: 'archivée', label: 'Archivée' },
            { value: 'en attente', label: 'En attente' }
        ],
        required: true,
        icon: faFileCircleCheck,
    },
    {
        name: 'name',
        label: 'Demandeur',
        type: 'select',
        options: _documentsRh.map(doc => ({
            value: doc.id,
            label: doc.name
        })),
        required: true
    },
    {
        name: 'uploadDate',
        label: 'Date de soumission',
        type: 'date',
        required: true,
        icon: faCalendar,
    },
    {
        name: 'metadata',
        label: 'Description',
        type: 'textarea',
        placeholder: 'Ajouter une description...',
        icon: faFileLines,
    },
    {
        name: 'type',
        label: 'Type de document',
        type: 'select',
        options: [
            { value: 'contrat', label: 'Contrat' },
            { value: 'attestation', label: 'Attestation' },
            { value: 'fiche de paie', label: 'Fiche de paie' },
            { value: 'autre', label: 'Autre' }
        ],
        required: true,
        icon: faTag,
    },
    {
        name: 'priority',
        label: 'Priorité',
        type: 'select',
        options: [
            { value: PrioriteDemande.BASSE, label: 'Basse' },
            { value: PrioriteDemande.NORMALE, label: 'Normale' },
            { value: PrioriteDemande.HAUTE, label: 'Haute' },
            { value: PrioriteDemande.URGENTE, label: 'Urgente' },
        ]
    },
    {
        name: 'customType',
        label: 'Préciser le type',
        type: 'text',
        required: (formData: Document) => formData?.type === 'autre',
        showWhen: (formData: Document) => formData?.type === 'autre' || false,
        icon: faListCheck
    },
]


