import { FormFieldType } from '@/shared/types/common';
import { IFormulaire } from '@/shared/types/formulaire';
import { faFileLines, faList, faFont, faBuilding, faUserTie, faNoteSticky, faIdCard } from '@fortawesome/free-solid-svg-icons';
import { CategoryMapping } from '../../styles';

export const formulaireFormFields: FormFieldType<IFormulaire>[] = [
  {
    name: 'title',
    label: 'Titre',
    type: 'text',
    placeholder: 'Titre du formulaire',
    required: true,
    icon: faFont,
  },
  {
    name: 'description',
    label: 'Description',
    type: 'textarea',
    placeholder: 'Description du formulaire',
    required: true,
    icon: faNoteSticky,
    multiline: true,
    rows: 3,
  },
  {
    name: 'category',
    label: 'Catégorie',
    type: 'select',
    placeholder: 'Sélectionnez une catégorie',
    required: true,
    icon: faList,
    options: Object.entries(CategoryMapping).map(([value, label]) => ({
      value,
      label,
    })),
  },
  {
    name: 'department',
    label: 'Département',
    type: 'text',
    placeholder: 'Département concerné',
    required: false,
    icon: faBuilding,
  },
  {
    name: 'creator',
    label: 'Créateur',
    type: 'text',
    placeholder: 'Nom du créateur',
    required: true,
    icon: faUserTie,
  },
]; 