import { IAppointment } from "@/shared/types/appointment";
import { FormFieldType } from "@/shared/types/common";
import { 
  DRIVERS, 
  MEDICAL_CENTER_OPTIONS, 
  DOCTOR_OPTIONS, 
  APPOINTMENT_STATUS,
  APPOINTMENT_TYPES
} from "@/shared/_mock/_appointment";
import { faClock } from "@fortawesome/free-solid-svg-icons";

export const formFields: FormFieldType<IAppointment>[] = [
  {
    name: 'driverName',
    label: 'Chauffeur',
    type: 'select',
    required: true,
    options: DRIVERS
  },
  {
    name: 'type',
    label: 'Type de rendez-vous',
    type: 'select',
    required: true,
    options: APPOINTMENT_TYPES
  },
  {
    name: 'otherType',
    label: 'Préciser le type',
    type: 'text',
    required: true,
     isDisabled: (values) => values.type !== 'Autre',
  },
  {
    name: 'medicalCenterId',
    label: 'Centre médical',
    type: 'select',
    required: false,
    options: MEDICAL_CENTER_OPTIONS,
   isDisabled: (values) => values.type !== 'Visite Médicale (médecine du travail)'
  },
  {
    name: 'doctorId',
    label: 'Médecin',
    type: 'select',
    required: false,
    options: DOCTOR_OPTIONS,
    isDisabled: (values) => values.type !== 'Visite Médicale (médecine du travail)'
  },
  {
    name: 'date',
    label: 'Date',
    type: 'date',
    required: true,
  },
  {
    name: 'time',
    label: 'Heure',
    type: 'time',
    required: true,
    icon:faClock
  },
  {
      name: 'status',
      label: 'Statut',
      type: 'select',
      required: true,
      options: APPOINTMENT_STATUS
    },
];