'use client';

import React from 'react';
import { Box, Typography, Checkbox, useTheme } from '@mui/material';
import { SvgIconComponent } from '@mui/icons-material';

interface NotificationSettingItemProps {
  icon: React.ReactElement;
  title: string;
  description: string;
  appChecked: boolean;
  emailChecked: boolean;
  onAppChange: (checked: boolean) => void;
  onEmailChange: (checked: boolean) => void;
}

const NotificationSettingItem = ({
  icon,
  title,
  description,
  appChecked,
  emailChecked,
  onAppChange,
  onEmailChange
}: NotificationSettingItemProps) => {
  const theme = useTheme();
  
  return (
    <>
      <Box sx={{ display: 'flex', alignItems: 'center' }}>
        <Box sx={{ mr: 2, color: theme.palette.primary.main }}>
          {icon}
        </Box>
        <Box>
          <Typography variant="body1">{title}</Typography>
          <Typography variant="body2" color="text.secondary">
            {description}
          </Typography>
        </Box>
      </Box>
      <Box className="checkbox-column" sx={{ height: '100%', display: 'flex', justifyContent: 'center', alignItems: 'center' }}>
        <Checkbox 
          checked={appChecked}
          onChange={(e) => onAppChange(e.target.checked)}
          color="primary"
        />
      </Box>
      <Box className="checkbox-column" sx={{ height: '100%', display: 'flex', justifyContent: 'center', alignItems: 'center' }}>
        <Checkbox 
          checked={emailChecked}
          onChange={(e) => onEmailChange(e.target.checked)}
          color="primary"
        />
      </Box>
    </>
  );
};

export default NotificationSettingItem;