'use client';

import React, { useEffect, useRef } from 'react';
import { Box, Stack } from '@mui/material';
import { HEADER } from '@/layouts/config-layout';
import TableControlBar from '@/shared/components/table/table-control-bar';
import TrajetTabs from '../../../components/tabs/tabs-custom';
import { useTrajetTabs } from '../hooks/use-trajet-tabs';
import TrajetTable from '../components/trajet-table';
import { useTrajetTable } from '../hooks/use-trajet-table';
import { ITrajet } from '@/shared/types/trajet';
import TrajetForm from './trajet-new-view';
import { TableType } from '../../../types/common';
import { useSearchParams } from 'next/navigation';
import { _trajets } from '@/shared/_mock/_trajets';

export default function TrajetListView() {
  const searchParams = useSearchParams();
  const trajetId = searchParams.get('id');
  const {
    tabs,
    activeTab,
    handleTabClose,
    handleTabChange,
    handleTabAdd,
    handleEdit,
    handleView,
    handleCancel,
  } = useTrajetTabs();

  const {
    table,
    filteredData,
    filters,
    tableHead,
    notFound,
    handleFilterChange,
    handleResetFilters,
    handleResetColumns,
    handleColumnsChange,
    handleSave,
    handleStatusChange,
    dataToExport
  } = useTrajetTable();

  const isFirstRender = useRef(true);

  useEffect(() => {
  if (trajetId && isFirstRender.current) {
    handleView(_trajets[1] as ITrajet);
    isFirstRender.current = false;
  }
  }, [handleView, trajetId]);
  
  const activeTabData = React.useMemo(() => {
    return tabs.find(tab => tab.id === activeTab);
  }, [tabs, activeTab]);

  return (
    <Box
      sx={{
        display: 'flex',
        flexDirection: 'column',
        height: `calc(100vh - ${HEADER.H_DESKTOP + 8}px)`,
      }}
    >
      <Stack
        flexGrow={0}
        direction="row"
        alignItems="center"
        justifyContent="flex-end"
        spacing={{ xs: 0.5, sm: 1 }}
      >
        <TableControlBar
          type = {TableType.Trajet}
          activeTab={activeTab}
          onResetFilters={handleResetFilters} 
          onResetColumns={handleResetColumns} 
          onColumnsChange={handleColumnsChange}
          initialColumns={tableHead.slice(0, -1)}
          onFilters={handleFilterChange}
          filteredData={dataToExport}
        />
      </Stack>

      <TrajetTabs
        type = {TableType.Trajet}
        tabs={tabs}
        activeTab={activeTab}
        handleTabChange={handleTabChange}
        handleTabClose={handleTabClose}
      />

      {activeTab === 'list' ? (
        <TrajetTable
          filteredData={filteredData}
          table={table}
          tableHead={tableHead}
          notFound={notFound}
          filters={filters}
          onFilterChange={handleFilterChange}
          handleEdit={handleEdit}
          handleView={handleView}
          onStatusChange={handleStatusChange}
        />
      ) : (
        <TrajetForm
          trajet={activeTabData?.content as ITrajet}
          mode={activeTabData?.mode || 'view'} 
          onSave={handleSave}
          onClose={() => handleCancel(activeTab)}
          onEdit={handleEdit}
          tableHead={tableHead.slice(0, -1)}
        />
      )}
    </Box>
  );
}

