import { AmendmentPassengerDetails } from '@/shared/types/ammendment-passenger';
import { FormFieldType } from '@/shared/types/common';
import { IAvenantUsager, ActionAvenantType } from '@/shared/types/usager';
import {
    faStickyNote,
    faListUl,
    faKeyboard,
    faGear,
  } from '@fortawesome/free-solid-svg-icons'
import { FormikAmendmentPassengerDetails } from '../components/usager-form/avenants-horaires/types/formik-types';
  
const ACTION_AVENANT_OPTIONS = [
  { value: ActionAvenantType.AJOUT_USAGER, label: 'Ajout usager' },
  { value: ActionAvenantType.SUPPRESSION_USAGER, label: 'Suppression usager' },
  { value: ActionAvenantType.MODIF_HORRAIRE, label: 'Modif horraire' },
  { value: ActionAvenantType.MODIF_ADRESSE, label: 'Modif adresse' }
];

export const usagerAvenantFormFields1=(
  etablissementOptions: { value: string; label: string }[],
) : FormFieldType<FormikAmendmentPassengerDetails & {etablissement: string}>[] => [
  {
    name: 'startDate',
    label: 'Début de transport',
    type: 'date',
    required: true,
    disabled: true,
  },
  {
    name: 'endDate',
    label: 'Au / Avenant temporaire/Stage',
    type: 'date',
    required: true,
    disabled: true,
  },
  {
    name: 'subject',
    label: 'Objet de l\'avenant',
    placeholder: 'Entrez l\'objet',
    type: 'text',
    icon: faKeyboard,
    required: true,
  },
  {
    name: 'etablissement',
    label: 'Etablissement',
    placeholder: 'Choisissez un nom',
    type: 'select',
    options: etablissementOptions,
    required: true,
  },
  {
    name: 'actionType',
    label: 'Action avenant',
    type: 'select',
    options: ACTION_AVENANT_OPTIONS,
    icon: faGear
  },
]

export const usagerAvenantFormFields2: FormFieldType<FormikAmendmentPassengerDetails>[] = [
  {
    name: 'specificity',
    label: 'Spécificité',
    placeholder: 'Entrez un texte',
    type: 'text',
    icon: faListUl,
  },
  {
    name: 'observation',
    label: 'Observation',
    placeholder: 'Ajoutez une note ou une observation',
    type: 'textarea',
    icon: faStickyNote,
    disabled: true,
  },
]
  