import { INITIAL_ADDRESS } from "../_mock";
import { AddressData } from "./common";

export interface ICandidature {
  id: string;
  nom: string;
  prenom: string;
  sourceCandidat: string;
  codePostal: string;
  ville: string;
  departement: string;
  age: number;
  email: string;
  telephone: string;
  dureePermis: string;
  suiviAppel: string;
  dateAppelRappel: string;
  dateCandidature: string;
  statut: CandidatureStatut;
  type?: 'Candidature chauffeur' | 'Candidature sédentaire';
  dateHeureRdvAgence?: string;
  observation?: string;
  raisonRefus?: string;
  contrat?: 'signé' | 'non signé';
  proximiteCircuit?: string;
  document?: string;
  disponibilite?: string;
  email_pro?: string;
  contrat_document?: File | string;
  address?: AddressData;
}

export enum CandidatureStatut {
  ATraiter = 'aTraiter',
  EnCours = 'enCours',
  Retenu = 'retenu',
  Valide = 'valide',
  Refuse = 'refuse',
  Blackliste = 'blackliste',
  Absent = 'absent'
}

export enum CandidatureContratStatut {
  Signe = 'signe',
  NonSigne = 'nonSigne'
}

export enum CandidatureTab {
  ATraiter = 'aTraiter',
  Formulaire = 'formulaire',
  Retenus = 'retenus',
  RdvSemaine = 'rdvSemaine',
  AbsentRdv = 'absentRdv',
  Tableau = 'tableau',
  Tous = 'tous',
  RefusesBlacklistes = 'refusesBlacklistes'
}

export interface IFormulaire {
  id: string;
  nom: string;
  lien: string;
  description: string;
}

export const INITIAL_CANDIDATURE_DATA: ICandidature = {
  id: '',
  nom: '',
  prenom: '',
  sourceCandidat: '',
  codePostal: '',
  ville: '',
  departement: '',
  age: 0,
  email: '',
  telephone: '',
  dureePermis: '',
  suiviAppel: '',
  dateAppelRappel: '',
  dateCandidature: new Date().toISOString().split('T')[0],
  statut: CandidatureStatut.ATraiter,
  type: 'Candidature chauffeur',
  contrat: 'non signé',
  email_pro: '',
  contrat_document: '',
  address: INITIAL_ADDRESS
}; 