import { Consumption } from "./consumption";

export type FuelCard = {
    firstName:string;
    lastName:string;
    cardNumber: string;
    tanker: string;
    lastUse: string;
  };
  
  export type GeolocData = {
    departureDate: string;
    arrivalDate: string;
    distance: number;
    carRegistration: string;
    departureLocation: string;
    arrivalLocation: string;
    justification: string;
    observation: string;
    causes: string;
  };
  
  export type EmailSentHistory = {
    dateSent: string;
    consumption?: Consumption;
    geoLoc?: GeolocData;
  };
  
export type IEmployee = {
    id: string;
    gender: string;
    firstName: string;
    lastName: string;
    circuit: string;
    address: string;
    zipCode: string;       
    city: string;
    phone: string;
    email: string;
    birthdate: string;     
    department: string;
    activity: string;      
    lastCardNumber: string;
    lastTanker: string;
    dateOfEntry: string;   
    fuelTypeCard: string;
    vehicule: string;
    fuelVolume: number;
    agencyCode: string;
    fuelCard: FuelCard[] | null;
    consumptions: Consumption[] | null;
    geolocData: GeolocData[] | null;
    lastNameFirstName: string | null;
    errors: string;
    dateImported: string;
    totalEmailsSent: number;
    totalKilometersTraveled: number;
    totalFuelCost: number;
    carRegistration: string;
    emailHistory: EmailSentHistory[] | null;
    transcolaire: string | null;
    correctData: boolean;
  };