export enum LeaveType {
  SICK = 'LEAVE_SICK',
  PARENTAL = 'LEAVE_PARENTAL',
  PAID = 'LEAVE_PAID',
  UNPAID = 'LEAVE_UNPAID',
  RTT = 'LEAVE_RTT'
}

export type AbsenceType = 
  | 'EXTERNAL_ASSIGNMENT'
  | 'PROFESSIONAL_TRAINING'
  | 'EXCEPTIONAL_TELEWORK'
  | 'AUTHORIZED_ABSENCE'
  | 'UNAUTHORIZED_ABSENCE'
  | 'MEDICAL_APPOINTMENT';

export type DemandeType = 
  | 'Absence'
  | 'Congé';

export type LeaveStatus = 
  | 'En attente'
  | 'En cours'
  | 'Approuvée'
  | 'Refusée'
  | 'Non traité'
  | 'Traité'
  | 'Annulé'
  | 'Waiting'
  | 'Unprocessed';

export type NotificationMode = 
  | 'SMS'
  | 'Email'
  | 'Application';

export interface ILeaveHistory {
  date: string;
  action: string;
  user: string;
  comment: string;
}
// Define API params type
export type ApiParams = {
  userId?: number;
  id?: string;
  submittedAt?: string;
  requestType?: 'LEAVE' | 'ABSENCE';
  startDate?: string;
  endDate?: string;
  state?: string;
  states?: string | string[];
  processedAt?: string;
  leaveType?: string;
  absenceType?: string;
  numberOfDays?: number;
  page: number;
  size: number;
  sort?: string[];
  search?: string;
};
export interface ILeave {
  isActive: boolean | undefined;
  id: string;
  employeeName: string;
  submissionDate: string;
  leaveType: LeaveType;
  startDate: string;
  endDate: string;
  status: LeaveStatus;
  processDate: string;
  notificationMode: NotificationMode;
  reason: string;
  daysCount: number;
  employeeId: string;
  history: ILeaveHistory[];
  dateDebut?: string;
  dateFin?: string;
  dateSubmission?: string;
  dateTraitement?: string;
  type?: LeaveType;
  modeReception?: NotificationMode;
  
}

export interface IDemandeAbsence {
  isActive: boolean | undefined;
  id: string;
  requestNumber: string;
  submissionDate: string;
  absenceType:string;
  requestType: DemandeType;
  leaveType: LeaveType | '';
  startDate: string;
  endDate: string;          
  status: LeaveStatus;
  processDate: string;
  reason: string;
  daysCount: number;
  employeeId: string;
  dateDebut?: string;
  dateFin?: string;
  dateSubmission?: string;
  dateTraitement?: string;
  type?: LeaveType;
  readOnly?: boolean;
  disabled?: boolean;
  title?: string;
}