import type { TableColumn } from "../types/common"

export interface INotification {
  id: string
  title: string
  message: string
  type: NotificationType
  category: NotificationCategory
  deliveryType: DeliveryType
  recipients: string[]
  sendImmediately: boolean
  scheduledDate?: string
  scheduledTime?: string
  attachment?: string
  channels: NotificationChannel[]
  status: NotificationStatus
  createdAt: string
  updatedAt: string
  readAt?: string
  isActive: boolean
}

export enum NotificationType {
  SYSTEM = "SYSTEM",
  PROFILE = "PROFILE",
  ACTIVITY = "ACTIVITY",
  ALERT = "ALERT",
  INFO = "INFO",
}

export enum NotificationCategory {
  INFO = "INFO",
  RAPPEL = "RAPPEL",
  ALERTE = "ALERTE",
  MAINTENANCE = "MAINTENANCE",
  MISE_A_JOUR = "MISE_A_JOUR",
}

export enum DeliveryType {
  IMMEDIAT = "IMMEDIAT",
  PLANIFIE = "PLANIFIE",
}

export enum NotificationChannel {
  EMAIL = "EMAIL",
  PUSH = "PUSH",
  SMS = "SMS",
}

export enum NotificationStatus {
  SENT = "SENT",
  PENDING = "PENDING",
  READ = "READ",
  UNREAD = "UNREAD",
  ARCHIVED = "ARCHIVED",
  DELETED = "DELETED",
}

export const DEFAULT_NOTIFICATION_TABLE_HEAD: TableColumn[] = [
  { id: "createdAt", label: "Date, heure", align: "left" },
  { id: "recipients", label: "Destination", align: "left" },
  { id: "deliveryType", label: "Type", align: "left" },
  { id: "category", label: "Catégorie", align: "left" },
  { id: "message", label: "Message", align: "left" },
  { id: "status", label: "Statut", align: "left" },
  { id: "actions", label: "Actions", align: "right" },
]

export const DEFAULT_NOTIFICATION_FILTERS = ["createdAt", "recipients", "deliveryType", "category", "status"]

export const INITIAL_NOTIFICATION_DATA: INotification = {
  id: "",
  title: "",
  message: "",
  type: NotificationType.INFO,
  category: NotificationCategory.INFO,
  deliveryType: DeliveryType.IMMEDIAT,
  recipients: [],
  sendImmediately: true,
  channels: [NotificationChannel.EMAIL, NotificationChannel.PUSH],
  status: NotificationStatus.PENDING,
  createdAt: new Date().toISOString().split("T")[0],
  updatedAt: new Date().toISOString().split("T")[0],
  isActive: true,
}
