export interface SessionData {
    id: string;
    device: {
        type: 'mac' | 'windows' | 'mobile' | 'tablet' | 'other';
        browser: string;
    };
    location: string;
    ip: string;
    lastUsed: string;
    lastUsedDate: Date;
    isCurrent?: boolean;
}

export const initialSessionsData: SessionData[] = [
    {
        id: '1',
        device: { type: 'mac', browser: 'safari' },
        location: 'Casablanca, Casablanca-Settat, Morocco',
        ip: '105.66.133.35',
        lastUsed: '26 Mar, 2025',
        lastUsedDate: new Date(2025, 2, 26),
        isCurrent: true
    },
    {
        id: '2',
        device: { type: 'windows', browser: 'chrome' },
        location: 'Casablanca, Casablanca-Settat, Morocco',
        ip: '196.118.189.144',
        lastUsed: '26 Mar, 2025',
        lastUsedDate: new Date(2025, 2, 26)
    },
    {
        id: '3',
        device: { type: 'mac', browser: 'chrome' },
        location: 'Casablanca, Casablanca-Settat, Morocco',
        ip: '105.66.133.35',
        lastUsed: '12 Feb, 2025',
        lastUsedDate: new Date(2025, 1, 12)
    }
];