import { ISector } from '@/shared/types/infrastructure';
import { TableColumn } from '../types/common';
import { INITIAL_ADDRESS, MOCK_ADDRESSES } from '.';

export const DEFAULT_SECTOR_TABLE_HEAD: TableColumn[] = [
    { id: 'code', label: 'Code', align: 'left' },
    { id: 'name', label: 'Nom', align: 'left' },
    { id: 'description', label: 'Description', align: 'left' },
    { id: 'createdAt', label: 'Créé le', align: 'left' },
    { id: 'updatedAt', label: 'Mis à jour le', align: 'left' },
    { id: 'agenciesNbr', label: 'Nombre d\'agences', align: 'left' },
];

export const INITIAL_SECTOR_DATA: ISector = {
    id: '',
    code: '',
    name: '',
    adresse:INITIAL_ADDRESS,
    description: '',
    createdAt: new Date().toISOString().split('T')[0],
    updatedAt: new Date().toISOString().split('T')[0],
    agenciesNbr: 0,
};

const getCurrentDate = () => new Date().toISOString().split('T')[0];

const generateAgency = (id: string, name: string, description: string, departmentsNbr: number) => ({
    id,
    name,
    adresse: MOCK_ADDRESSES[Math.floor(Math.random() * MOCK_ADDRESSES.length)],
    description,
    createdAt: getCurrentDate(),
    updatedAt: getCurrentDate(),
    departmentsNbr,
});

// Liste des secteurs avec leurs informations
const sectorList = [
    { code: "SEC001", name: 'Secteur Nord', description: 'Région nord de la ville', agenciesNbr: 3 },
    { code: "SEC002", name: 'Secteur Sud', description: 'Région sud de la ville', agenciesNbr: 4 },
    { code: "SEC003", name: 'Secteur Est', description: 'Région est de la ville', agenciesNbr: 2 },
    { code: "SEC004", name: 'Secteur Ouest', description: 'Région ouest de la ville', agenciesNbr: 5 },
    { code: "SEC005", name: 'Secteur Centre', description: 'Centre-ville', agenciesNbr: 6 },
    { code: "SEC006", name: 'Secteur Industriel', description: 'Zone industrielle', agenciesNbr: 3 },
    { code: "SEC007", name: 'Secteur Commercial', description: 'Zone commerciale', agenciesNbr: 4 },
    { code: "SEC008", name: 'Secteur Résidentiel', description: 'Quartiers résidentiels', agenciesNbr: 5 },
    { code: "SEC009", name: 'Secteur Touristique', description: 'Zone touristique', agenciesNbr: 2 },
    { code: "SEC010", name: 'Secteur Portuaire', description: 'Zone portuaire', agenciesNbr: 3 },
    { code: "SEC011", name: 'Secteur Rural', description: 'Zone rurale', agenciesNbr: 1 },
    { code: "SEC012", name: 'Secteur Universitaire', description: 'Campus universitaire', agenciesNbr: 2 },
    { code: "SEC013", name: 'Secteur Historique', description: 'Centre historique', agenciesNbr: 3 }
];

// Génération des secteurs de manière dynamique
export const _sectors: ISector[] = sectorList.map((sector, index) => ({
    id: (index + 1).toString(),
    code: sector.code,
    name: sector.name,
    adresse: MOCK_ADDRESSES[Math.floor(Math.random() * MOCK_ADDRESSES.length)],
    description: sector.description,
    createdAt: getCurrentDate(),
    updatedAt: getCurrentDate(),
    agenciesNbr: sector.agenciesNbr,
    agencies: [
        generateAgency("2", 'Agence 2', 'Description 2', 2),
        generateAgency("3", 'Agence 3', 'Description 3', 3),
        generateAgency("4", 'Agence 4', 'Description 4', 1)
    ]
}));