import { _noms, _prenoms, ADRESSE, generatePhoneNumber } from ".";
import { Etat } from "../types/circuit";
import { TableColumn } from "../types/common";
import { Departements } from "../types/etablissement";
import { DaysOfWeek, IPassengerList } from "../types/passenger";
import { IUsager } from "../types/usager";
import { State, CustodyCategory } from "../types/passenger";
import { ScheduleHoursDTO } from "../components/form/schedule-table";


const _etablissements = [
  "Lycée Victor Hugo",
  "Collège Jean Moulin",
  "École Primaire Jules Ferry",
];
export const _classes = [
  "2nde", "1ère", "Terminale",
  "CP", "CE1", "CE2", "CM1", "CM2"
];
const _types =['Papa', 'Maman'];
const _villes = [
  "Paris", "Lyon", "Marseille", "Bordeaux", "Lille",
  "Toulouse", "Nantes", "Strasbourg", "Montpellier"
];
export const DAYS = ["Lundi", "Mardi", "Mercredi", "Jeudi", "Vendredi", "Samedi", "Dimanche"]

export const DEFAULT_USAGER_TABLE_HEAD: TableColumn[] = [
  { id: 'id', label: 'N° Usager', type: 'text', align: 'left' },
  { id: 'firstName', label: 'Prénom', type: 'text', align: 'left' },
  { id: 'lastName', label: 'Nom', type: 'text', align: 'left' },
  { id: 'birthDate', label: 'Date de naissance', type: 'date', align: 'center' },
  { id: 'birthPlace', label: 'Lieu de naissance', type: 'text', align: 'left' },
  { id: 'establishmentName', label: 'Établissement', type: 'text', align: 'left' },
  { id: 'schoolClass', label: 'Classe', type: 'text', align: 'left' },
  { id: 'address', label: 'Adresse', type: 'text', align: 'left' },
  { id: 'state', label: 'Etat', type: 'status', align: 'left' },
  { id: 'lastAmendmentDate', label: 'avenant du', type: 'text', align: 'left' },
  { id: 'code', label: 'Code', type: 'text', align: 'left' },
  { id: 'type', label: 'Type', type: 'text', align: 'left' },
  { id: 'email', label: 'E-mail', type: 'text', align: 'left' },
  { id: 'landlinePhoneNumbers', label: 'Téléphone', type: 'text', align: 'left' },
  { id: 'mobilePhoneNumbers', label: 'Mobile', type: 'text', align: 'left' },
  { id: 'startTransport', label: 'Entrée le', type: 'date', align: 'center' },
  { id: 'departmentName', label: 'Département', type: 'text', align: 'center' },
  { id: 'observations', label: 'Observations', type: 'text', align: 'left' },
  { id: 'isActive', label: 'Active', type: 'boolean', align: 'center' },
  { id: '', label: 'Action' },
  ];
  export const DEFAULT_CIRCUIT_USAGER_TABLE_HEAD: TableColumn[] = [
    { id: 'id', label: 'N° Usager', type: 'text' },
    { id: 'lastName', label: 'Nom', type: 'text', align: 'left' },
    { id: 'firstName', label: 'Prénom', type: 'text', align: 'left' },
    { id: 'birthDate', label: 'Date de naissance', type: 'date', align: 'center' },
    { id: 'birthPlace', label: 'Lieu de naissance', type: 'text', align: 'left' },
    { id: 'establishmentName', label: 'Établissement', type: 'text', align: 'left' },
    { id: 'schoolClass', label: 'Classe', type: 'text', align: 'left' },
    { id: 'address', label: 'Adresse', type: 'text', align: 'left' },
    { id: 'scheduleAmendment', label: 'Avenant Horaires', type: 'text', align: 'center' },
    { id: 'isActive', label: 'Active', type: 'boolean', align: 'center' },
    { id: '', label: 'Action' },
  ];
  
  export const INITIAL_USAGER_DATA: IPassengerList = {
    id: '',
    firstName: '',
    lastName: '',
    birthDate: '',
    birthPlace: '',
    establishmentTransportSchedules: [],
    schoolClass: null,
    phoneNumber: '',
    state: State.UNCONTROLLED,
    startTransport: '',
    specificity: '',
    particularityTransport: null,
    referentTeacherName: '',
    custodyCategory: CustodyCategory.ALTERNATING_CUSTODY,
    email: '',
    openingDays: '',
    departmentName: '',
    observations: '',
    archived: false,
    representatives: [],
    interlocutor: null,
    idDepartment: 0,
    lastAmendmentDate: '',
    age: 0,
    roles: []
  };

export const _documentsRows = [
  {
    id: 'D-0000001',
    label: 'RIB',
    usager: 'Jean Duppont',
    dateImportation: '2020-01-15',
    dateFin: '2024-01-15',
  },
  {
    id: 'D-0000002',
    label: 'Contrat de collaboration professionnelle',
    usager: 'Jean Duppont',
    dateImportation: '2020-01-15',
    dateFin: '2024-01-15',
  },
];

export const _usagers: IUsager[] = [...Array(30)].map((_, index) => {
  const birthDate = new Date(2008 + Math.floor(index / 12), index % 12, 15);
  const entryDate = new Date(2022+ Math.floor(index / 12), index % 12, 15);
  const avenantDate = new Date(2023+ Math.floor(index / 12), index % 12, 15);
  const departementsArray = Object.values(Departements);

  return {
    id: (index + 1).toString(),
    civilite: '',
    nom: _noms[index % 4],
    prenom: _prenoms[index % 4],
    dateNaissance: birthDate.toISOString().split('T')[0],
    lieuNaissance: _villes[index % _villes.length],
    etablissement: _etablissements[index % _etablissements.length],
    classe: _classes[index % _classes.length],
    adresse:  ADRESSE[index % ADRESSE.length],
    etat: index % 3 === 0 ? 'controle' : 'non_controle',
    avenantDu: avenantDate.toISOString().split('T')[0],
    code: `VSN${index.toString().padStart(3, '0')}`,
    type: _types[index % 2],
    responsibleName: `${['Dupont', 'Durand', 'Morel', 'Laurent'][index % 4]} ${['Jean', 'Marie', 'Pierre', 'Sophie'][index % 4]}`,
    email: `${_noms[index % 4]}@gmail.com`,
    tel: generatePhoneNumber('+33'),
    mobile: generatePhoneNumber('+33'),
    entreeLe: entryDate.toISOString().split('T')[0],
    department: departementsArray[index % departementsArray.length],
    observation: 'Ce bus facilite les déplacements urbains',
    isActive: Math.random() < 0.3,
};
});


export const DEPO_DOCUMENT_TABLE_HEAD : TableColumn[] = [
  { id: 'createdAt', label: 'Date de création', align: 'center' },
  { id: 'name', label: 'Nom', align: 'center' },
  { id: 'downloadUrl', label: 'Télécharger', align: 'center' },
  { id: 'actions', label: 'Actions', align: 'center' },
]

export const mockEstablishmentScheduleData: ScheduleHoursDTO[] = [
  {
    id: 1,
    dayOfWeek: DaysOfWeek.MONDAY,
    morningOpeningTime: "07:00:00",
    eveningClosingTime: "19:00:00",
  },
  {
    id: 2,
    dayOfWeek: DaysOfWeek.TUESDAY,
    morningOpeningTime: "07:00:00",
    eveningClosingTime: "19:00:00",
  },
  {
    id: 3,
    dayOfWeek: DaysOfWeek.WEDNESDAY,
    morningOpeningTime: "07:00:00",
    eveningClosingTime: "19:00:00",
  },
  {
    id: 4,
    dayOfWeek: DaysOfWeek.THURSDAY,
    morningOpeningTime: "07:00:00",
    eveningClosingTime: "19:00:00",
  },
  {
    id: 5,
    dayOfWeek: DaysOfWeek.FRIDAY,
    morningOpeningTime: "07:00:00",
    eveningClosingTime: "19:00:00",
  },
  {
    id: 6,
    dayOfWeek: DaysOfWeek.SATURDAY,
    morningOpeningTime: "08:00:00",
    eveningClosingTime: "18:00:00",
  },
  {
    id: 7,
    dayOfWeek: DaysOfWeek.SUNDAY,
    morningOpeningTime: "09:00:00",
    eveningClosingTime: "17:00:00",
  },
]

// Mock data pour le mode semaines (avec weekType)
export const mockWeekScheduleData: ScheduleHoursDTO[] = [
  // Semaine paire
  {
    id: 1,
    dayOfWeek: DaysOfWeek.MONDAY,
    morningOpeningTime: "08:00:00", // All pour semaine paire
    eveningClosingTime: "17:00:00", // Ret pour semaine paire
    weekType: "pair",
  },
  {
    id: 2,
    dayOfWeek: DaysOfWeek.TUESDAY,
    morningOpeningTime: "08:00:00",
    eveningClosingTime: "17:00:00",
    weekType: "pair",
  },
  {
    id: 3,
    dayOfWeek: DaysOfWeek.WEDNESDAY,
    morningOpeningTime: "08:00:00",
    eveningClosingTime: "17:00:00",
    weekType: "pair",
  },
  {
    id: 4,
    dayOfWeek: DaysOfWeek.THURSDAY,
    morningOpeningTime: "08:00:00",
    eveningClosingTime: "17:00:00",
    weekType: "pair",
  },
  {
    id: 5,
    dayOfWeek: DaysOfWeek.FRIDAY,
    morningOpeningTime: "08:00:00",
    eveningClosingTime: "17:00:00",
    weekType: "pair",
  },
  {
    id: 6,
    dayOfWeek: DaysOfWeek.SATURDAY,
    morningOpeningTime: "09:00:00",
    eveningClosingTime: "16:00:00",
    weekType: "pair",
  },
  {
    id: 7,
    dayOfWeek: DaysOfWeek.SUNDAY,
    morningOpeningTime: "10:00:00",
    eveningClosingTime: "15:00:00",
    weekType: "pair",
  },
  // Semaine impaire
  {
    id: 8,
    dayOfWeek: DaysOfWeek.MONDAY,
    morningOpeningTime: "09:00:00", // All pour semaine impaire
    eveningClosingTime: "18:00:00", // Ret pour semaine impaire
    weekType: "impair",
  },
  {
    id: 9,
        dayOfWeek: DaysOfWeek.TUESDAY,
    morningOpeningTime: "09:00:00",
    eveningClosingTime: "18:00:00",
    weekType: "impair",
  },
  {
    id: 10,
    dayOfWeek: DaysOfWeek.WEDNESDAY,
    morningOpeningTime: "09:00:00",
    eveningClosingTime: "18:00:00",
    weekType: "impair",
  },
  {
    id: 11,
    dayOfWeek: DaysOfWeek.THURSDAY,
    morningOpeningTime: "09:00:00",
    eveningClosingTime: "18:00:00",
    weekType: "impair",
  },
  {
    id: 12,
    dayOfWeek: DaysOfWeek.FRIDAY,
    morningOpeningTime: "09:00:00",
    eveningClosingTime: "18:00:00",
    weekType: "impair",
  },
  {
    id: 13,
    dayOfWeek: DaysOfWeek.SATURDAY,
    morningOpeningTime: "10:00:00",
    eveningClosingTime: "17:00:00",
    weekType: "impair",
  },
  {
    id: 14,
    dayOfWeek: DaysOfWeek.SUNDAY,
    morningOpeningTime: "11:00:00",
    eveningClosingTime: "16:00:00",
    weekType: "impair",
  },
]