const endpointPrefix = "/api/hr/calendar/events";

export const calendarEndpoints = {
  events: {
    getAll: endpointPrefix,
    getById: (id: string | number) => `${endpointPrefix}/${id}`,
    create: endpointPrefix,
    update: (id: string | number) => `${endpointPrefix}/${id}`,
    delete: (id: string | number) => `${endpointPrefix}/${id}`,
  },
  employees: {
    getDrivers: "/api/user/driver/allDrivers",
    getAgencies: "/api/admin/infrastructure/agencies/all-names-ids",
  },
  notifications: {
    getIntervals: "/api/hr/notifications/intervals",
  }
};