import { add } from 'date-fns';

const endpointPrefix = '/api/roadMap';

export const roadMapEndpoints = {
  roadMap: {
    validaRoadMap: {
      getAllValidRoadmap: endpointPrefix + '/validatedRoadMaps',
      add: endpointPrefix + '/validatedRoadMaps/add',
      getOldRoadmapByDriver: (id: number) => `${endpointPrefix}/validatedRoadMaps/driver/${id}`,
      getAllDelaValidRoadmap: endpointPrefix + '/validatedRoadMaps/deal',
    },
    submittedRoadMap: {
      getAllsubmittedRoadmap: endpointPrefix + '/submittedRoadMaps',
      getOldSubmittedRoadmaps: endpointPrefix + '/submittedRoadMaps/old',
      getOldSubmittedRoadmapDetails: (id: number) => `${endpointPrefix}/submittedRoadMaps/${id}`,
      create: `${endpointPrefix}/create`,
    },
    statistics: {
      getStatistics: `${endpointPrefix}/statistics`,
    },
  },
  workedDay: {
    getByDate: `${endpointPrefix}/workedDay/by-date`,
    createOrUpdate: `${endpointPrefix}/workedDay/create-or-update`,
    getDriverInfo: (id: number) => `${endpointPrefix}/driver/infos/${id}`,
  },
};
