import type React from "react"
import { Grid, Box, Typography } from "@mui/material"
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome"
import type { IconDefinition } from "@fortawesome/fontawesome-svg-core"
import FontAwesome from "@/shared/components/fontawesome"
import { pxToRem } from "@/shared/theme/typography"

export interface StatCardProps {
  title: string
  subtitle: string
  value: string
  color: "primary" | "success" | "warning" | "error"
  icon: IconDefinition
}

interface StatCardsProps {
  data: StatCardProps[]
}

const StatCards: React.FC<StatCardsProps> = ({ data }) => {
  return (
    <Grid container spacing={2}>
      {data.map((card, index) => (
        <Grid item xs={12} sm={6} md={3} key={index}>
          <Box
            sx={{
              p: 2,
              height: "100%",
              borderRadius: '12px',
              bgcolor: "background.paper",
              boxShadow: "0 0 8px rgba(0,0,0,0.1)",
              display: "flex",
              justifyContent: "space-between",
              alignItems: "center",
            }}
          >
            <Box>
              <Typography variant="subtitle1" sx={{fontWeight:600}}>
                {card.title}
              </Typography>
              <Typography variant="caption" color="text.secondary" display="block">
                {card.subtitle}
              </Typography>
              <Typography sx={{fontSize:pxToRem(24)}}  fontWeight="bold" mt={1}>
                {card.value}
              </Typography>
            </Box>
            <Box
              sx={{
                width: 69,
                height: 69,
                borderRadius: "23px",
                display: "flex",
                alignItems: "center",
                justifyContent: "center",
                bgcolor: `${card.color}.lighter`,
                color: `${card.color}.main`,
              }}
            >
              <FontAwesome icon={card.icon} width={30} />
            </Box>
          </Box>
        </Grid>
      ))}
    </Grid>
  )
}

export default StatCards

