"use client"

import Box from "@mui/material/Box"
import Image from "next/image"

// ----------------------------------------------------------------------

type Props = {
  imgUrl?: string
}

export default function SingleFilePreview({ imgUrl = "" }: Props) {
  return (
    <Box
      sx={{
        p: 1,
        top: 0,
        left: 0,
        width: 1,
        height: 1,
        position: "absolute",
      }}
    >
      <div style={{ position: "relative", width: "100%", height: "100%", borderRadius: "8px", overflow: "hidden" }}>
        {imgUrl ? (
          <Image
            alt="file preview"
            src={imgUrl || "/placeholder.svg"}
            fill
            style={{ objectFit: "cover" }}
            sizes="(max-width: 768px) 100vw, 300px"
          />
        ):<></>}
      </div>
    </Box>
  )
}

