import { TabConfig, useTabsManager } from '@/hooks/use-tabs-manager';
import { TeamList, IEquipe, TeamStatus } from '@/shared/types/equipe';

const initialValues: TeamList = {
  id: '',
  teamCode: '',
  name: '',
  teamLeaderName: '',
  departmentName: '',
  creationDate: '',
  status: TeamStatus.INACTIVE
};

const equipeConfig: TabConfig<TeamList | IEquipe> = {
  type: 'equipe',
  listTitle: 'Liste des équipes',
  newItemTitle: 'Nouvelle équipe',
  initialData: initialValues,
  getItemCode: (team) => team.teamCode,
};

export function useEquipeTabs() {
  return useTabsManager<TeamList | IEquipe>(equipeConfig);
}