import { ROLE_STATUS } from '@/shared/_mock/_roles';
import { FormFieldType } from '@/shared/types/common';
import { IRole } from '@/shared/types/role';
import { 
  faShieldHalved, 
  faCircleInfo, 
  faListCheck,
  faToggleOn,
  faCalendarDays,
  faPlusCircle,
  faSitemap
} from '@fortawesome/free-solid-svg-icons';

export const formFields: FormFieldType<IRole>[] = [
  {
    name: 'name',
    label: 'Nom du rôle',
    type: 'text',
    placeholder: 'Entrez le nom du rôle',
    required: true,
    icon: faShieldHalved,
  },
  {
    name: 'modules',
    label: 'Modules et Sections',
    type: 'custom',
    placeholder: 'Sélectionner les modules',
    required: true,
    icon: faSitemap, 
  },
  {
    name: 'description',
    label: 'Description',
    type: 'textarea',
    placeholder: 'Description détaillée du rôle',
    required: true,
    icon: faCircleInfo,
  },
  
  {
    name: 'createdAt',
    label: 'Date de création',
    type: 'date',
    placeholder: 'Date de création du rôle',
    required: false,
    icon: faCalendarDays,
  },
  
  {
    name: 'status',
    label: 'Statut',
    type: 'select',
    options: ROLE_STATUS,
    required: true,

  },
];