import { BaseStyledRow } from '@/shared/sections/contract/styles';
import { Chip, ChipProps, Box, BoxProps, TextField } from '@mui/material';
import { alpha, styled } from '@mui/material/styles';


export const AgentStyledRow = styled(BaseStyledRow)(({ theme }) => ({
  backgroundColor: 'white',
  '& > *': {
    borderTop: `3px solid ${alpha(theme.palette.primary.main, 0.1)}`,
  },
}));

export const RoleStyledRow = styled(BaseStyledRow)(({ theme }) => ({
  backgroundColor: 'white',
  '& > *': {
    borderTop: `3px solid ${alpha(theme.palette.primary.main, 0.1)}`,
  },
}));

export const EquipeStyledRow = styled(BaseStyledRow)(({ theme }) => ({
  backgroundColor: 'white',
  '& > *': {
    borderTop: `3px solid ${alpha(theme.palette.primary.main, 0.1)}`,
  },
  '&:hover': {
    backgroundColor: alpha(theme.palette.primary.main, 0.02),
  },
  '&.Mui-selected': {
    backgroundColor: alpha(theme.palette.primary.main, 0.08),
    '&:hover': {
      backgroundColor: alpha(theme.palette.primary.main, 0.12),
    },
  },
}));

export const StatusChip = styled(Chip)(({ status, theme }: { status: string; theme: any }) => ({
  '&.MuiChip-root': {
    fontWeight: 500,
    borderRadius: '8px',
    padding: '9px 0',
    height: '100%',
    width: '100%',
    ...(status === 'APPROVED' && {
      backgroundColor: '#E9FBF0',
      color: '#36B37E',
    }),
    ...(status === 'PENDING' && {
      backgroundColor: '#FEF8E7',
      color: '#F9B90B',
    }),
    ...(status === 'BANNED' && {
      backgroundColor: '#FFE1E1',
      color: '#FF3434',
    }),
    ...(status === 'active' && {
      backgroundColor: '#E9FBF0',  
      color: '#36B37E', 
    }),
    ...(status === 'inactive' && {
      backgroundColor: '#FFE1E1',  
      color: '#FF3434', 
    }),
      ...(status === 'ACTIVE' && {
      backgroundColor: '#E9FBF0',  
      color: '#36B37E', 
    }),
    ...(status === 'INACTIVE' && {
      backgroundColor: '#FFE1E1',  
      color: '#FF3434', 
    }),
    ...(status === 'DELETED' && {
      backgroundColor: alpha('#7A0BC0', 0.1),
      color: '#7A0BC0',
    }),
  },
}));

const permissionColors = {
  lire: { bg: 'rgba(130, 112, 196, 0.1)', color: '#8270C4', border: '1px solid rgba(130, 112, 196, 0.3)' },
  ecrire: { bg: 'rgba(105, 81, 188, 0.1)', color: '#6951BC', border: '1px solid rgba(105, 81, 188, 0.3)' },
  modifier: { bg: 'rgba(86, 56, 169, 0.1)', color: '#5638A9', border: '1px solid rgba(86, 56, 169, 0.3)' },
  supprimer: { bg: 'rgba(62, 35, 143, 0.1)', color: '#3E238F', border: '1px solid rgba(62, 35, 143, 0.3)' },
  read: { bg: 'rgba(130, 112, 196, 0.1)', color: '#8270C4', border: '1px solid rgba(130, 112, 196, 0.3)' },
  write: { bg: 'rgba(105, 81, 188, 0.1)', color: '#6951BC', border: '1px solid rgba(105, 81, 188, 0.3)' },
  edit: { bg: 'rgba(86, 56, 169, 0.1)', color: '#5638A9', border: '1px solid rgba(86, 56, 169, 0.3)' },
  delete: { bg: 'rgba(62, 35, 143, 0.1)', color: '#3E238F', border: '1px solid rgba(62, 35, 143, 0.3)' },
  default: { bg: 'rgba(130, 112, 196, 0.1)', color: '#8270C4', border: '1px solid rgba(130, 112, 196, 0.3)' }
};
export const PermissionChip = styled(Chip)(({ label, theme }: ChipProps & { theme: any }) => {
  const permission = String(label || '');
  const colors = permissionColors[permission as keyof typeof permissionColors] || permissionColors.default;
  
  return {
    '&.MuiChip-root': {
      backgroundColor: colors.bg,
      color: colors.color,
      border: colors.border,
      fontWeight: 600,
      fontSize: '0.75rem',
      borderRadius: '12px',
      textTransform: 'capitalize',
      margin: '3px',
      padding: '4px 0',
      height: '24px',
      '&:hover': {
        backgroundColor: colors.bg,
        opacity: 0.9,
      },
    },
  };
});

export const getStatusColor = (status: string) => {
  switch (status) {
    case 'APPROVED':
      return '#36B37E';
    case 'PENDING':
      return '#F9B90B'; 
    case 'BANNED':
      return '#FF3434'; 
    case 'DELETED':
      return '#7A0BC0'; 
    default:
      return '#81919A';
  }
};

export const ModulesRoleStyledRow = styled(BaseStyledRow)(({ theme }) => ({
  backgroundColor: 'white',
  '& > *': {
    borderTop: `3px solid ${alpha(theme.palette.primary.main, 0.1)}`,
  },
  '&:hover': {
    backgroundColor: alpha(theme.palette.primary.main, 0.02),
  },
  '&.Mui-selected': {
    backgroundColor: alpha(theme.palette.primary.main, 0.08),
    '&:hover': {
      backgroundColor: alpha(theme.palette.primary.main, 0.12),
    },
  },
}));

export const EquipeAgentsStyledRow = styled(BaseStyledRow)(({ theme }) => ({
  backgroundColor: 'white',
  height: '47px',
  '&:not(:last-child)': {
    borderBottom: `3px solid ${alpha(theme.palette.primary.main, 0.1)}`,
    borderTop: `3px solid ${alpha(theme.palette.primary.main, 0.1)}`,
  },
  '&:hover': {
    transition: 'border 0.3s',
    backgroundColor: alpha(theme.palette.primary.main, 0.02),
  },
}));

export const HistoryStyledRow = styled(BaseStyledRow)(({ theme }) => ({
  backgroundColor: 'white',
  height: '47px',
  '&:not(:last-child)': {
    borderBottom: `3px solid ${alpha(theme.palette.primary.main, 0.1)}`,
    borderTop: `3px solid ${alpha(theme.palette.primary.main, 0.1)}`,
  },
  '&:hover': {
    transition: 'border 0.3s',
    backgroundColor: alpha(theme.palette.primary.main, 0.02),
  },
}));
const StyledTextField = styled(TextField)(({ theme }) => ({
  '& .MuiOutlinedInput-root': {
    '& fieldset': {
      borderColor: 'rgba(130, 112, 196, 0.2)',
    },
    '&:hover fieldset': {
      borderColor: 'rgba(130, 112, 196, 0.3)',
    },
    '&.Mui-focused fieldset': {
      borderColor: theme.palette.primary.main,
    },
  },
  '& .MuiInputLabel-root': {
    color: 'rgba(0, 0, 0, 0.6)',
    '&.Mui-focused': {
      color: theme.palette.primary.main,
    },
  },
}));