import React, { useEffect, useState } from 'react';
import {
    Button,
    Dialog,
    DialogActions,
    DialogContent,
    Grid,
    IconButton,
    Typography,
} from '@mui/material';
import CloseIcon from '@mui/icons-material/Close';
import { StyledDialog, StyledDialogTitle } from '../../rh/styles';
import { faXmark } from '@fortawesome/free-solid-svg-icons';
import FontAwesome from '@/shared/components/fontawesome';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';

interface PopupFormProps {
    formContent: React.ReactNode;
    onSave?: () => void;
    onCloseCallback?: () => void;
    title?: string;
    onOpen?: boolean;
}

export const PopupForm: React.FC<PopupFormProps> = ({
    formContent,
    onSave,
    onCloseCallback,
    title = 'Form',
    onOpen,
}) => {
    const [open, setOpen] = useState(false);
    useEffect(() => {
        if (onOpen) setOpen(onOpen);
    }, [onOpen]);
    const handleClose = () => {
        setOpen(false);
        if (onCloseCallback) onCloseCallback();
    };

    const handleSave = () => {
        if (onSave) onSave();
        handleClose();
    };

    return (
        <>
            <StyledDialog
                open={open}
                onClose={handleClose}
                maxWidth="sm"
                fullWidth
            >

                <StyledDialogTitle >
                    <Typography variant="h6">
                        {title}        </Typography>
                    <IconButton
                        onClick={handleClose}
                        size="small"
                        sx={{
                            position: 'absolute',
                            right: 8,
                            top: 8
                        }}
                    >
                        <FontAwesome width={20} icon={faXmark} />
                    </IconButton>
                </StyledDialogTitle>

                <DialogContent sx={{ padding: 0 }}>
                    <Grid container direction="column" spacing={2}>
                        <Grid item>{formContent}</Grid>
                    </Grid>
                </DialogContent>
            </StyledDialog>
        </>
    );
};