import { TabConfig, useTabsManager } from '@/hooks/use-tabs-manager';
import { _AddNewRoadmap, _driversRoadmap, INITIAL_NEW_ROADMAP_DATA } from '@/shared/_mock/_roadMap';
import { IAddRoadmap } from '@/shared/types/driver';


  const clientConfig: TabConfig<IAddRoadmap> = {
    type: 'roadmap',
    listTitle: 'Liste des feuilles de route',
    newItemTitle: 'Nouvelle feuille de route',
    initialData: INITIAL_NEW_ROADMAP_DATA,
    getItemCode: (roadmap: { title: any }) => roadmap.title,
  };


export function useAddNewProadMapTabs() {
  return useTabsManager<IAddRoadmap>(clientConfig);
}

