import { Dialog, DialogTitle, DialogContent, DialogActions, Button, Stack, Typography, IconButton, Box } from '@mui/material';
import { Close as CloseIcon } from '@mui/icons-material';
import { StyledDialog } from '@/shared/sections/rh/styles';
import { dialogTitleStyles, dialogTitleTextStyles } from '@/shared/theme/css';
import FontAwesome from '@/shared/components/fontawesome';
import { faRocketchat } from '@fortawesome/free-brands-svg-icons';

export default function ContactMethodDialog({
  open,
  onClose,
  onSelect,
}: {
  open: boolean;
  onClose: () => void;
  onSelect: (method: 'email' | 'sms' | 'internalChat') => void;
}) {
  return (
    <StyledDialog open={open} onClose={onClose} fullWidth>
      <DialogTitle sx={(theme) => dialogTitleStyles(theme)}>
        <Box sx={{ display: 'flex', alignItems: 'center', gap: 1 }}>
          <FontAwesome icon={faRocketchat} width={20} />
          <Typography variant="h6" sx={dialogTitleTextStyles}>
            Choisir un canal de communication
          </Typography>
        </Box>
        <IconButton aria-label="close" onClick={onClose} size="small" sx={{ color: 'white' }}>
          <CloseIcon />
        </IconButton>
      </DialogTitle>

      <DialogContent sx={{ marginTop: '24px' }}>
        <Stack spacing={3}>
          <Button
            onClick={() => onSelect('sms')}
            variant="outlined"
            fullWidth
            sx={{
              padding: '16px',
              borderRadius: '8px',
              color: 'primary.main',
              borderColor: 'primary.main',
              '&:hover': {
                borderColor: 'primary.dark',
                color: 'primary.dark',
              },
            }}
          >
            SMS
          </Button>
          <Button
            onClick={() => onSelect('email')}
            variant="outlined"
            fullWidth
            sx={{
              padding: '16px',
              borderRadius: '8px',
              color: 'primary.main',
              borderColor: 'primary.main',
              '&:hover': {
                borderColor: 'primary.dark',
                color: 'primary.dark',
              },
            }}
          >
            Email
          </Button>
          <Button
            onClick={() => onSelect('internalChat')}
            variant="outlined"
            fullWidth
            sx={{
              padding: '16px',
              borderRadius: '8px',
              color: 'primary.main',
              borderColor: 'primary.main',
              '&:hover': {
                borderColor: 'primary.dark',
                color: 'primary.dark',
              },
            }}
          >
            Chat interne
          </Button>
        </Stack>
      </DialogContent>

      <DialogActions sx={{ padding: '16px 24px', backgroundColor: '#fafafa' }}>
        <Button
          variant="outlined"
          onClick={onClose}
          sx={{
            borderRadius: '8px',
            padding: '8px 16px',
            color: 'primary.main',
            borderColor: 'primary.main',
            '&:hover': {
              borderColor: 'primary.dark',
              color: 'primary.dark',
            },
          }}
        >
          Annuler
        </Button>
      </DialogActions>
    </StyledDialog>
  );
}
