import * as Yup from 'yup';

export const circuitContractSchema = Yup.object().shape({
  contrat: Yup.string().required('Le contrat est requis'),
  numeroLot: Yup.array().of(Yup.string()).min(1, 'Au moins un numéro de lot est requis'),
}); 

export const circuitSchema = Yup.object().shape({
  circuitState: Yup.string().required('Le circuit est requis'),
  circuitCode: Yup.string().required('code circuit est requis'),
  titled: Yup.string().required('Intitule du circuit est requis'),
  mainEstablishment: Yup.number().required('L\'établissement principal est requis')
  .test('is-greater-than-zero', 'L\'établissement doit être valide', value => value !== undefined && value > 0),
  calculationType: Yup.string(),
  startDate: Yup.string().required('La date de début est requise'),
  endDate: Yup.string()
    .required('La date de fin est requise')
    .test(
      'is-after-start',
      'La date de fin doit être après la date de début',
      function (endDate) {
        const { startDate } = this.parent;
        return new Date(endDate) > new Date(startDate);
      }
    ),
  colorCode: Yup.string(),
  mainDriver: Yup.string().nullable(),
  observation: Yup.string().nullable(),
  contractCode: Yup.string(),
  lotNumber: Yup.string(),
});

export const chauffeurSchema = Yup.object().shape({
  assignmentStartDate: Yup.string().required('La date de début est requise'),
  assignmentEndDate: Yup.string().required('La date de fin est requise'),
  tripId: Yup.string().required('Le trajet est requis'),
  driverId: Yup.string().required('Le chauffeur est requis'),
  observations: Yup.string().nullable(),
}); 