import { type TableConfig, useTableManager } from "@/hooks/use-table-manager"
import { _VehicleModels, DEFAULT_VEHICLE_MODEL_TABLE_HEAD } from "@/shared/_mock/flottes/_vehicle"
import { IVehicleModel } from "@/shared/types/flottes/vehicule"

const vehicleModelConfig: TableConfig<IVehicleModel> = {
  initialData: _VehicleModels,
  defaultTableHead: DEFAULT_VEHICLE_MODEL_TABLE_HEAD,
}

export function useVehicleModelTable() {
  return useTableManager<IVehicleModel>(vehicleModelConfig)
}
