import { FormFieldType } from '@/shared/types/common';
import {
  faHashtag,
  faUserTie,
  faFileAlt,
  faCalendarAlt,
  faUserCheck,
  faBuilding,
  faExchangeAlt,
  faClipboardCheck,
  faIdBadge
} from '@fortawesome/free-solid-svg-icons';
import { IRHAbsence } from '../../../../types/absence-rh';
import { UserOption } from '@/shared/types/absence-rh';
import { _CHAUFFEURS, _MODES_RECEPTION, _TYPES_ABSENCE, _DEPARTEMENTS } from '@/shared/_mock/_rhAbsence';
import { DRIVERS } from '@/shared/_mock/_appointment';
import { _BINARY_Qst } from '@/shared/_mock/_trajets';
import { _OPTION_DRIVER_ABSENCE } from '@/shared/_mock/_absenceDriver';

export type OptionType = {
  value: string;
  label: string;
};

export const createFormFieldsRHAbsence = (
  allUsers: UserOption[] = [],
  collaborators: UserOption[] = []
): FormFieldType<IRHAbsence>[] => [
  {
    name: 'nomChauffeur',
    label: 'Nom',
    type: 'select',
    required: true,
    options: allUsers.map(user => ({ value: user.label, label: user.label })),
    icon: faUserTie
  },
  {
    name: 'type',
    label: 'Type',
    type: 'select',
    required: true,
    disabled: true,
    options: [
      { value: 'chauffeur', label: 'Chauffeur' },
      { value: 'sédentaire', label: 'Sédentaire' }
    ],
    icon: faIdBadge
  },
  {
    name: 'typeAbsence',
    label: 'Type d\'absence',
    type: 'select',
    required: true,
    options: [
      { value: 'EXTERNAL_ASSIGNMENT', label: 'Mission externe' },
      { value: 'PROFESSIONAL_TRAINING', label: 'Formation professionnelle' },
      { value: 'EXCEPTIONAL_REMOTE_WORK', label: 'Télétravail exceptionnel' },
      { value: 'AUTHORIZED_ABSENCE', label: 'Absence autorisée' },
      { value: 'UNAUTHORIZED_ABSENCE', label: 'Absence non autorisée' },
      { value: 'MEDICAL_APPOINTMENT', label: 'Rendez-vous médical' }
    ],
    icon: faClipboardCheck
  },
  {
    name: 'dateDebut',
    label: 'Date de début',
    type: 'date',
    required: true,
    icon: faCalendarAlt
  },
  {
    name: 'dateFin',
    label: 'Date de fin',
    type: 'date',
    required: true,
    icon: faCalendarAlt
  },
  {
    name: 'modeReception',
    label: 'Mode de réception',
    type: 'select',
    required: true,
    options: [
      { value: 'APPLICATION', label: 'Application' },
      { value: 'EMAIL', label: 'Email' },
      { value: 'PHONE', label: 'Téléphone' },
      { value: 'PORTAL', label: 'Portail' }
    ],
    icon: faExchangeAlt
  },
  {
    name: 'justificatif',
    label: 'Justificatif',
    placeholder: 'Certificat médical',
    type: 'text',
    required: false,
    icon: faFileAlt
  },
  {
    name: 'affecteTrajet',
    label: 'Affecte un trajet',
    type: "checkbox",
    disabled: true,
    options: [
      { value: 'true', label: 'Oui' },
      { value: 'false', label: 'Non' }
    ]
  },
  {
    name: 'statut',
    label: 'Statut',
    type: 'select',
    required: true,
    options: [
      { value: 'Unprocessed', label: 'Non traité' },
      { value: 'Waiting', label: 'En attente' },
      { value: 'In_progress', label: 'En cours' },
      { value: 'Approved', label: 'Approuvé' },
      { value: 'Rejected', label: 'Rejeté' },
      { value: 'Cancelled', label: 'Annulé' }
    ]
  },
  {
    name: 'nbrHeures',
    label: 'Nbr des heures',
    type: 'number',
    required: true,
    icon: faHashtag
  },
  {
    name: "autorisePar",
    label: "Autorisé Par",
    type: "select",
    required: false,
    options: collaborators.map(collab => ({ value: collab.label, label: collab.label })),
    icon: faUserCheck
  },
  {
    name: "validerPar",
    label: "Validé Par",
    type: "select",
    required: false,
    options: collaborators.map(collab => ({ value: collab.label, label: collab.label })),
    icon: faUserCheck
  },
  {
    name: 'departement',
    label: 'Département',
    type: 'text',
    required: true,
    disabled: true,
    icon: faBuilding
  }
];