import { 
    Dialog, 
    DialogTitle, 
    DialogContent, 
    Table, 
    TableHead, 
    TableRow, 
    TableCell, 
    TableBody,
    IconButton
  } from '@mui/material';
  import { Close as CloseIcon } from '@mui/icons-material';
  import { ILeaveHistory } from '@/shared/types/leave';
  import { format } from 'date-fns';
  import { fr } from 'date-fns/locale';
  
  interface HistoriqueDialogProps {
    open: boolean;
    onClose: () => void;
    historique: ILeaveHistory[];
  }
  
  export default function HistoriqueDialog({ open, onClose, historique }: HistoriqueDialogProps) {
    return (
      <Dialog open={open} onClose={onClose} maxWidth="md" fullWidth>
        <DialogTitle>
          Historique des actions
          <IconButton
            aria-label="close"
            onClick={onClose}
            sx={{ position: 'absolute', right: 8, top: 8 }}
          >
            <CloseIcon />
          </IconButton>
        </DialogTitle>
        <DialogContent>
          <Table>
            <TableHead>
              <TableRow>
                <TableCell>Date</TableCell>
                <TableCell>Action</TableCell>
                <TableCell>Utilisateur</TableCell>
                <TableCell>Motif</TableCell>
              </TableRow>
            </TableHead>
            <TableBody>
              {historique.map((item, index) => (
                <TableRow key={index}>
                  <TableCell>
                    {format(new Date(item.date), 'dd/MM/yyyy HH:mm', { locale: fr })}
                  </TableCell>
                  <TableCell>{item.action}</TableCell>
                  <TableCell>{item.user}</TableCell>
                  <TableCell>{item.comment || '-'}</TableCell>
                </TableRow>
              ))}
            </TableBody>
          </Table>
        </DialogContent>
      </Dialog>
    );
  }