import { outlinedColor } from '@/shared/components/table/styles';
import { StyledTextField } from '@/shared/theme/css';
import { pxToRem } from '@/shared/theme/typography';
import {
  Dialog,
  DialogTitle,
  DialogContent,
  DialogActions,
  Button,
  TextField,
  Stack,
  Typography,
} from '@mui/material';

type SendDocumentDialogProps = {
  open: boolean;
  onClose: () => void;
  onSend: (data: { recipient: string; subject: string; content: string }) => void;
  recipientName?: string;
};

export default function SendDocumentDialog({
  open,
  onClose,
  onSend,
  recipientName = '',
}: SendDocumentDialogProps) {
  const handleSubmit = (event: React.FormEvent<HTMLFormElement>) => {
    event.preventDefault();
    const formData = new FormData(event.currentTarget);
    onSend({
      recipient: formData.get('recipient') as string,
      subject: formData.get('subject') as string,
      content: formData.get('content') as string,
    });
  };

  return (
    <Dialog open={open} onClose={onClose} maxWidth="md" fullWidth>
      <DialogTitle
        sx={{
          fontSize: pxToRem(25),
          m: 'auto',
          color: 'primary.main',
          fontWeight: (theme) => theme.typography.fontWeightBold,
        }}
      >
        Envoyer le document au demandeur
      </DialogTitle>
      <form onSubmit={handleSubmit}>
        <DialogContent>
          <Stack spacing={3}>
            <StyledTextField
              fullWidth
              label="Destinataire"
              name="recipient"
              defaultValue={recipientName}
              InputProps={{
                readOnly: true,
              }}
            />
            <StyledTextField fullWidth label="Objet du message" name="subject" required />
            <StyledTextField
              fullWidth
              label="Contenu du message"
              name="content"
              multiline
              rows={6}
              required
            />
          </Stack>
        </DialogContent>
        <DialogActions>
          <Button
            sx={{
              ...outlinedColor,
            }}
            variant="outlined"
            onClick={onClose}
          >
            Annuler
          </Button>
          <Button type="submit" variant="contained">
            Envoyer
          </Button>
        </DialogActions>
      </form>
    </Dialog>
  );
}
