  import * as Yup from "yup"

  export const documentSchema = Yup.object().shape({
    name: Yup.string().required("Le nom du document est obligatoire"),
    status: Yup.string()
      .oneOf(['non traité', 'traité', 'archivée', 'en attente'], "Statut invalide")
      .required("Le statut est obligatoire"),
    type: Yup.string()
      .oneOf(['contrat', 'attestation', 'fiche de paie', 'autre'], "Type de document invalide")
      .required("Le type de document est obligatoire"),
    uploadDate: Yup.date().required("La date de soumission est requise"),
    metadata: Yup.string().nullable(),
    customType: Yup.string().when("type", {
      is: "autre",
      then: (schema) => schema.required("Veuillez préciser le type de document"),
      otherwise: (schema) => schema.nullable(),
    }),
  });
