import React from 'react';
import { IAppointment } from '@/shared/types/appointment';
import { TableColumn } from '@/shared/types/common';
import TableManager from '@/shared/components/table/table-manager';
import AppointmentTableRow from '../views/appointment-table-row';
import { Box } from '@mui/material';
import { tableStyles } from '../stytles';

interface AppointmentTableProps {
  filteredData: IAppointment[];
  table: ReturnType<typeof import('@/shared/components/table/use-tablets').default>;
  tableHead: TableColumn[];
  notFound: boolean;
  filters: Record<string, { value: string; condition: string }>;
  onFilterChange: (key: string, value: string, condition: string) => void;
  handleEdit?: (item: IAppointment) => void;
  handleView?: (item: IAppointment) => void;
  handleCancel?: (item: IAppointment) => void;
}

export default function AppointmentTable({
  filteredData,
  table,
  tableHead,
  notFound,
  filters,
  onFilterChange,
  handleEdit,
  handleView,
  handleCancel,
}: AppointmentTableProps) {
  const renderRow = (row: IAppointment) => (
    <AppointmentTableRow
      key={row.id}
      row={row}
      handleEdit={handleEdit}
      handleView={handleView}
      handleCancel={handleCancel}
      selected={table.selected.includes(row.id)}
      onSelectRow={() => table.onSelectRow(row.id)}
      columns={tableHead.slice(0, -1)}
    />
  );

  return (
   <Box sx={tableStyles.root}>
    <TableManager
      filteredData={filteredData}
      table={table}
      tableHead={tableHead}
      notFound={notFound}
      filters={filters}
      isDrawer
      fixedHeight="calc(100vh - 136px)"
      sx={{ backgroundColor: 'primary.lighter', pr: 0}}
      onFilterChange={onFilterChange}
      renderRow={renderRow}
    />
 </Box>
  );
}