import { Pageable } from './client';
import { CircuitMap, User } from './Maps';

export enum GeolocStatus {
  PLANNED = 'Planifié',
  IN_PROGRESS = 'En cours',
  COMPLETED = 'Terminé',
  FAILED = 'Échoué'
}

export interface IGeolocItem {
  id: string;
  status: GeolocStatus;
  nomChauffeur: string;
  prenomChauffeur: string;
  vehicule: string;
  vehiculeId: string;
  distance: number;
  duree: string;           // Format: "2h45"
  vitesseMoyenne: number;  // En km/h
  consommation: string;    // En L/100km
  departureDate: string;   // ISO string
  arrivalDate: string;     // ISO string
  adresseDepart: string;
  adresseArrivee: string;
  agence: string;
  departement: string;
  secteur: string;
  routes?: CircuitMap[];   
  tolls?: User[];
  dateDepart: string;
  dateArrivee: string;
}

export interface IGeolocHistory {
  id: string;
  driverName: string;
  carRegistration: string;
  tripDate: string;
  agence: string;
  departement: string;
  secteur: string;
  trips: ITrip[]; 
}

export interface ITrip {
  id: string;
  duration: string; 
  distance: number; 
  startHour: string; 
  endHour: string;   
  departure_address: string;
  arrival_address: string;
  avg_speed: number; 
  points: ITripPoint[];
}

export interface ITripPoint {
  id: string;
  address: string;
  latitude: number;
  longitude: number;
}
  export type IGeolocHistoryPageable = Pageable<IGeolocHistory>;

export interface GeolocHistoryFilterParams {
  id?: string;
  carRegistration?: string;
  driverName?: string;
  startDate?: string; 
  endDate?: string;
  sortBy?: string;
  sortDirection?: 'asc' | 'desc';
  page?: number;
  size?: number;
}
