'use client';
import React, { createContext, useContext, useState, ReactNode } from 'react';

interface NavBarContextProps {
  isNavBarMinimized: boolean;
  toggleNavBar: () => void;
}

const NavBarContext = createContext<NavBarContextProps | undefined>(undefined);

export const NavBarProvider = ({ children }: { children: ReactNode }) => {
  const [isNavBarMinimized, toggleNavBarMinimized] = useState(false);

  const toggleNavBar = () => {
    toggleNavBarMinimized((prev) => !prev);
  };

  return (
    <NavBarContext.Provider value={{ isNavBarMinimized, toggleNavBar }}>
      {children}
    </NavBarContext.Provider>
  );
};

export const useNavBar = () => {
  const context = useContext(NavBarContext);
  if (!context) {
    throw new Error('useNavBar must be used within a NavBarProvider');
  }
  return context;
};
