import IconButton from '@mui/material/IconButton';
import FontAwesome from '@/shared/components/fontawesome';
import { faCar } from '@fortawesome/free-solid-svg-icons';
import CustomTooltip from '@/shared/components/tooltips/tooltip-custom';
import { WhiteIconButtonStyle } from '@/shared/theme/css';
import { useRouter } from 'next/navigation';
import { paths } from '@/routes/paths';

// ----------------------------------------------------------------------

export default function DrivePopover() {
  const router = useRouter();

  const handlePlanningClick = () => {
    router.push(paths.dashboard.planning.vehicule);
  };
  return (
    <CustomTooltip title="Planning véhicules" arrow  >
      <IconButton sx={WhiteIconButtonStyle} onClick={handlePlanningClick}>
      <FontAwesome icon={faCar} />
    </IconButton>
    </CustomTooltip>

  );
}