import IconButton from '@mui/material/IconButton';
import SvgColor from '@/shared/components/svg-color';
import CustomPopover, { usePopover } from '@/shared/components/custom-popover';
import { Grid, Typography } from '@mui/material';
import { useNavData } from '../dashboard/config-navigation';
import { Box } from '@mui/system';
import { bgBlur, WhiteIconButtonStyle } from '@/shared/theme/css';
import { useTheme } from '@mui/material/styles';
import { usePathname, useResponsive, useRouter } from '@/hooks';
import { pxToRem } from '@/shared/theme/typography';
import CustomTooltip from '@/shared/components/tooltips/tooltip-custom';

// ----------------------------------------------------------------------

export default function MenuPopover() {
  const popover = usePopover();
  const { rootMenuList } = useNavData(35);
  const theme = useTheme();
  const router = useRouter();
  const currentPath = usePathname();
  const isLgTo1600  = useResponsive('between',1300, 1560);
  const isLgDown  = useResponsive('down', 1300);
  const isSmTo1050  = useResponsive('down', 1050);
  const isSmDown  = useResponsive('down', 'sm');

  const handleNavigation = (path: string) => {
    popover.onClose();
    router.push(path);
  };
  return (
    <>
    <CustomTooltip title="Menu" arrow  >
      <IconButton
        onClick={popover.onOpen}
        sx={WhiteIconButtonStyle}
      >
        <SvgColor src="/assets/icons/navbar/ic_menu_item.svg" sx={{width : {  xs: 20, lg: 22},height:{  xs: 20, lg: 22}}}/>
      </IconButton>
      </CustomTooltip>
      <CustomPopover
        arrow="top-left"
        hiddenArrow={true}
        open={popover.open}
        onClose={popover.onClose}
        sx={{
          width: '25%',
          borderRadius: 4,
          px: '1%',
          py: '2%',
          mt: '0.8%',
          ...(isLgTo1600  && {width: '28%'}),
           ...(isLgDown  && {width: 400}),
          ...(isSmTo1050  && { width: '40%'}),
          ...(isSmDown  && { width: '55%'}),
        }}
      >
        <Grid container rowSpacing={2}   justifyContent="left">
          {rootMenuList.map((item, index) => {
            const isActive = currentPath.startsWith(item.path);

            return (
              <Grid  item key={index} xs={4} sm={4} md={3}>
                <Box
                  onClick={() => handleNavigation(item.path)}
                  sx={{
                    display: 'flex',
                    flexDirection: 'column',
                    alignItems: 'center',
                    padding: 0,
                    '&:hover, &.active': {
                      '.hover-box': {
                        border: `1px solid ${theme.palette.primary.main}`,
                        ...bgBlur({
                          color: theme.palette.primary.main,
                          opacity: 0.1,
                        }),
                      },
                      '.hover-text': {
                        color: theme.palette.primary.main,
                      },
                    },
                  }}
                  className={isActive ? 'active' : ''}
                >
                  <IconButton
                    className="hover-box"
                    sx={{
                      ...bgBlur({
                        color: theme.palette.primary.main,
                        opacity: 0.1,
                      }),
                      width: '65%',
                      aspectRatio: '1 / 1',
                      display: 'flex',
                      borderRadius: 3,
                      border: `1px solid ${isActive ? theme.palette.primary.main : 'transparent'}`,
                      marginBottom: 1,
                      color: theme.palette.primary.main,
                    }}
                  >
                    {item.icon}
                  </IconButton>
                  <Typography
                    className="hover-text"
                    sx={{
                      textAlign: 'center',
                      fontSize: pxToRem(13.5),
                      ...(isSmTo1050  && { fontSize: pxToRem(11) }),
                      ...(isLgDown  && { fontSize: theme.typography.caption }),
                      ...(isLgTo1600  && { fontSize: theme.typography.caption }),
                      color: isActive ? theme.palette.primary.main : 'inherit',
                      fontFamily: "'Inter-Medium', Helvetica",
                    }}
                  >
                    {item.title}
                  </Typography>
                </Box>
              </Grid>
            );
          })}
        </Grid>
      </CustomPopover>
    </>
  );
}
