import IconButton from '@mui/material/IconButton';
import SvgColor from '@/shared/components/svg-color';
import CustomTooltip from '@/shared/components/tooltips/tooltip-custom';
import { WhiteIconButtonStyle } from '@/shared/theme/css';
import { useRouter } from 'next/navigation';
import { paths } from '@/routes/paths';
import FontAwesome from '@/shared/components/fontawesome';
import { faCalendar } from '@fortawesome/free-regular-svg-icons';

// ----------------------------------------------------------------------

export default function PlaningLocation() {
  const router = useRouter();

  const handlePlanningClick = () => {
    router.push(paths.dashboard.planning.location);
  };

  return (
    <CustomTooltip title="Planning Location" arrow>
      <IconButton sx={WhiteIconButtonStyle} onClick={handlePlanningClick}>
        <FontAwesome icon={faCalendar} width= {{ xs: 20, lg: 22 }}/>
      </IconButton>
    </CustomTooltip>
  );
}