import Box, { BoxProps } from '@mui/material/Box';

import { useResponsive } from '@/hooks';

//import { useSettingsContext } from '@/shared/components/settings';

import { NAV, HEADER } from '../config-layout';
import { useNavBar } from '@/contexts/settings/nav-bar-context';
import Footer from './footer';

// ----------------------------------------------------------------------

const SPACING = 8;

export default function Main({ children, sx, ...other }: BoxProps) {
  const lgUp = useResponsive('up', 'lg');
  const isSmallScreen = useResponsive('down', 'lg');

  const { isNavBarMinimized, toggleNavBar } = useNavBar();
  return (
    <Box
      component="main"
      sx={{
        flexGrow: 1,
        minHeight: 1,
        display: 'flex',
        flexDirection: 'column',
        pt: `${lgUp ? HEADER.H_DESKTOP : HEADER.H_MOBILE + SPACING}px`,
        px: 2,
        width: `calc(100% - ${
          isSmallScreen
            ? isNavBarMinimized
              ? NAV.W_MINI
              : NAV.W_VERTICAL
            : isNavBarMinimized
            ? NAV.W_MINI
            : NAV.W_VERTICAL
        }px)`,
        ...sx,
      }}
      {...other}
    >
      {children}
      <Footer />
    </Box>
  );
}
