import { useEffect } from 'react';

import Box from '@mui/material/Box';
import Stack from '@mui/material/Stack';
import { usePathname } from '@/hooks';
import Logo from '@/shared/components/logo';
import Scrollbar from '@/shared/components/scrollbar';
import { BORDER, NAV } from '../config-layout';
import { useNavData } from './config-navigation';
import NavToggleButton from '../common/nav-toggle-button';
import NavSectionVertical from '@/shared/components/nav-section/vertical/nav-section-vertical';
import { common } from '@/shared/theme/palette';
import { grey, palette } from '../../shared/theme/palette';
import { useTheme } from '@mui/material';

// ----------------------------------------------------------------------

type Props = {
  openNav: boolean;
  onCloseNav: VoidFunction;
};


export default function NavVertical({ openNav, onCloseNav }: Props) {
  const pathname = usePathname();
  const { navData } = useNavData(22);
  const theme = useTheme();
  useEffect(() => {
    if (openNav) {
      onCloseNav();
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [pathname]);

  const renderContent = (<>
  
      <Logo sx={{ mt: 1, mx: 'auto', mb: 1 }} />
      <Scrollbar
        sx={{
          height: 1,
          overflowY: 'auto',
          '&::-webkit-scrollbar': {
            width: '8px',
          },
          '&::-webkit-scrollbar-thumb': {
            backgroundColor: theme.palette.grey[400],
          },
          '& .simplebar-placeholder': {
            display: 'none !important',
          },
        }}
      >
        <NavSectionVertical data={navData} />
      </Scrollbar>
    </>
  );

  return (
    <Box
      sx={{
        bgcolor: common.white,
        borderRadius: BORDER.RADIUS_NAV,
        flexShrink: 0 ,
        width: NAV.W_VERTICAL,
      }}
    >
      <NavToggleButton
        sx={{
          left: NAV.W_VERTICAL - 12,
        }}
      />
      <Stack
        sx={{
          height: 1,
          position: 'fixed',
          width: NAV.W_VERTICAL,
          borderRight: (theme) => `dashed 1px ${theme.palette.divider}`,
          borderRadius: BORDER.RADIUS_NAV,
        }}
      >
        {renderContent}
      </Stack>
    </Box>
  );
}
