// ----------------------------------------------------------------------

const ROOTS = {
  AUTH: '/auth',
  DASHBOARD: '/dashboard',
};

// ----------------------------------------------------------------------

// Définition des chemins d'accès dans l'application
export const paths = {
  // AUTH
  auth: {
    jwt: {
      login: `${ROOTS.AUTH}/jwt/login`,
      signIn: `${ROOTS.AUTH}/jwt/sign-in`,
      signUp: `${ROOTS.AUTH}/jwt/sign-up`,
    },
  },
  // DASHBOARD
    dashboard: {
      root: ROOTS.DASHBOARD,
      exploitation: {
        root: `${ROOTS.DASHBOARD}/exploitation`,
        circuitUsager: {
          root: `${ROOTS.DASHBOARD}/exploitation/circuit-usager`,
          usager: `${ROOTS.DASHBOARD}/exploitation/circuit-usager/usager`,
          circuit: `${ROOTS.DASHBOARD}/exploitation/circuit-usager/circuit`,
          trajet: `${ROOTS.DASHBOARD}/exploitation/circuit-usager/trajet`,
          avenant: `${ROOTS.DASHBOARD}/exploitation/circuit-usager/avenant`,
          absence: `${ROOTS.DASHBOARD}/exploitation/circuit-usager/absence`,
        },
        contract: `${ROOTS.DASHBOARD}/exploitation/contract`,
        client: `${ROOTS.DASHBOARD}/exploitation/client`,
        establishment: {
          root: `${ROOTS.DASHBOARD}/exploitation/establishment`,
          liste: `${ROOTS.DASHBOARD}/exploitation/establishment/liste`,
          vacance: `${ROOTS.DASHBOARD}/exploitation/establishment/vacance`,
          feuillePresence: `${ROOTS.DASHBOARD}/exploitation/establishment/feuille-presence`,
        },
        chauffeur: {
          root: `${ROOTS.DASHBOARD}/exploitation/chauffeur`,
          liste: `${ROOTS.DASHBOARD}/exploitation/chauffeur/liste`,
          planning: `${ROOTS.DASHBOARD}/exploitation/chauffeur/planning`,
          feuilleRoute: `${ROOTS.DASHBOARD}/exploitation/chauffeur/feuille-route`,
          envoiFeuilleRoute: `${ROOTS.DASHBOARD}/exploitation/chauffeur/feuille-route/add-new-roadmap`,
          submittedRoadMap: `${ROOTS.DASHBOARD}/exploitation/chauffeur/feuille-route/submitted-roadmap`,
          suiviTrajet: `${ROOTS.DASHBOARD}/exploitation/chauffeur/suivi-trajet`,
          absence: `${ROOTS.DASHBOARD}/exploitation/chauffeur/absence`,
        },
        tad: `${ROOTS.DASHBOARD}/exploitation/tad`,
        preparation: {
          root: `${ROOTS.DASHBOARD}/exploitation/preparation`,
          usager: `${ROOTS.DASHBOARD}/exploitation/preparation/usager`,
          circuit: `${ROOTS.DASHBOARD}/exploitation/preparation/circuit`,
          chauffeur: `${ROOTS.DASHBOARD}/exploitation/preparation/chauffeur`,
        },
        gestionFlottes: {
          root: `${ROOTS.DASHBOARD}/exploitation/gestion_flottes`,
          location: `${ROOTS.DASHBOARD}/exploitation/gestion_flottes/location`,
          vehicule: `${ROOTS.DASHBOARD}/exploitation/gestion_flottes/vehicule`,
          entretien: `${ROOTS.DASHBOARD}/exploitation/gestion_flottes/entretien`,
          assurance: `${ROOTS.DASHBOARD}/exploitation/gestion_flottes/assurance`,
          incidents: `${ROOTS.DASHBOARD}/exploitation/gestion_flottes/incidents`,
        },
        carburant: {
          root: `${ROOTS.DASHBOARD}/exploitation/carburant`,
          suiviCarburant: `${ROOTS.DASHBOARD}/exploitation/carburant/suivi_carburant`,
          suiviKilometrage: `${ROOTS.DASHBOARD}/exploitation/carburant/suivi_kilometrage`,
          anomalieTraitee: `${ROOTS.DASHBOARD}/exploitation/carburant/anomalie_traitee`,
        },
      },
      configAdmin: {
        root: `${ROOTS.DASHBOARD}/config-admin`,
        infrastructure: `${ROOTS.DASHBOARD}/config-admin/infrastructure`,
        agentRole: `${ROOTS.DASHBOARD}/config-admin/agent-role`,
        email: `${ROOTS.DASHBOARD}/config-admin/email`,
        notification: `${ROOTS.DASHBOARD}/config-admin/notification`,
      },
      facturationPaiement: {
        root: `${ROOTS.DASHBOARD}/facturation-paiement`,
      },
      flottes: {
        root: `${ROOTS.DASHBOARD}/flottes`,
        location: `${ROOTS.DASHBOARD}/flottes/location`,
        vehicule: {
          root: `${ROOTS.DASHBOARD}/flottes/vehicule`,
          parc: `${ROOTS.DASHBOARD}/flottes/vehicule/parc`,
          carburant: {
            root:`${ROOTS.DASHBOARD}/flottes/vehicule/carburant`,
            Fees: `${ROOTS.DASHBOARD}/flottes/vehicule/carburant/frais`,
            Import : `${ROOTS.DASHBOARD}/flottes/vehicule/carburant/import`,
            Tanker : `${ROOTS.DASHBOARD}/flottes/vehicule/carburant/petrolier`,
          },
          listes: {
            root: `${ROOTS.DASHBOARD}/flottes/vehicule/listes`,
            marques: `${ROOTS.DASHBOARD}/flottes/vehicule/listes/marques-modeles`,
            reparation: `${ROOTS.DASHBOARD}/flottes/vehicule/listes/reparation-types`,
            sinistres: `${ROOTS.DASHBOARD}/flottes/vehicule/listes/types-sinistres`,
            vehicules: `${ROOTS.DASHBOARD}/flottes/vehicule/listes/types-vehicules`,
            supplier: `${ROOTS.DASHBOARD}/flottes/vehicule/listes/types-fournisseurs`,
          },
        },

        entretien: `${ROOTS.DASHBOARD}/flottes/entretien`,
        affectation: `${ROOTS.DASHBOARD}/flottes/affectation`,
        incidents: `${ROOTS.DASHBOARD}/flottes/incidents`,
        consommation : {
          root: `${ROOTS.DASHBOARD}/flottes/consommation`,
          carburant: `${ROOTS.DASHBOARD}/flottes/consommation/carburant`,
          kilometrage: `${ROOTS.DASHBOARD}/flottes/consommation/kilometrage`,
          anomalie: `${ROOTS.DASHBOARD}/flottes/consommation/anomalie`,
        }
      },
      geolocalisation: {
        root: `${ROOTS.DASHBOARD}/geolocalisation`,
        history: `${ROOTS.DASHBOARD}/geolocalisation/history`,
      },
      appelOffre: {
        root: `${ROOTS.DASHBOARD}/appel-offre`,
      },
      planning: {
        root: `${ROOTS.DASHBOARD}/planning`,
        vehicule: `${ROOTS.DASHBOARD}/planning/vehicule`,
        chauffeur: `${ROOTS.DASHBOARD}/planning/chauffeur`,
        location: `${ROOTS.DASHBOARD}/planning/location`,
      },
      rh: {
        root: `${ROOTS.DASHBOARD}/rh`,
        embauche: {
          root: `${ROOTS.DASHBOARD}/rh/recrutement`,
          candidatures: `${ROOTS.DASHBOARD}/rh/recrutement/candidatures`,
          candidaturesSedentaire: `${ROOTS.DASHBOARD}/rh/recrutement/candidatures-sedentaire`,
          besoinsRecrutement: `${ROOTS.DASHBOARD}/rh/recrutement/besoins-recrutement`,
          formulaire: `${ROOTS.DASHBOARD}/rh/recrutement/formulaire`,
        },
        salarié: `${ROOTS.DASHBOARD}/rh/salarie`,
        calendar: `${ROOTS.DASHBOARD}/rh/calendar`,
        absence: `${ROOTS.DASHBOARD}/rh/absence`,
        conge: `${ROOTS.DASHBOARD}/rh/conge`,
        rdvAnnuel: `${ROOTS.DASHBOARD}/rh/rdv-annuel`,
        document: `${ROOTS.DASHBOARD}/rh/document`,
      },
      staff: {
        root: `${ROOTS.DASHBOARD}/staff`,
        absence:`${ROOTS.DASHBOARD}/staff/absence`,
        document:`${ROOTS.DASHBOARD}/staff/document`,
        profil:`${ROOTS.DASHBOARD}/staff/profil`,
        email:`${ROOTS.DASHBOARD}/staff/email`,
        profilDetails:`${ROOTS.DASHBOARD}/staff/profil/information`,
        profilStatus:`${ROOTS.DASHBOARD}/staff/profil/status`,
        profilNotifications:`${ROOTS.DASHBOARD}/staff/profil/notifications`,
        profilLanguesAndRegion:`${ROOTS.DASHBOARD}/staff/profil/languesandregion`,
        profilpassword:`${ROOTS.DASHBOARD}/staff/profil/password`,
        profilsessionHistorique:`${ROOTS.DASHBOARD}/staff/profil/sessionHistorique`,
      },
      export: {
        root: `${ROOTS.DASHBOARD}/export`,
      },
  }
};
// Définition des points d'API
export const endpoints = {
  chat: '/api/chat',
  kanban: '/api/kanban',
  calendar: '/api/calendar',
  auth: {
    me: '/api/auth/me',
    login: '/api/auth/login',
    register: '/api/auth/register',
  },
  mail: {
    list: '/api/mail/list',
    details: '/api/mail/details',
    labels: '/api/mail/labels',
  },
  post: {
    list: '/api/post/list',
    details: '/api/post/details',
    latest: '/api/post/latest',
    search: '/api/post/search',
  },
  product: {
    list: '/api/product/list',
    details: '/api/product/details',
    search: '/api/product/search',
  },
};

