import {LeaveType, LeaveStatus, IDemandeAbsence } from '@/shared/types/leave';



const _reuestNumber =["1234567890","1234567891","1234567892","1234567893","1234567894","1234567895","1234567896","1234567897","1234567898","1234567899"]

const _REASONS = [
  "Maladie nécessitant un repos",
  "Congé parental pour naissance",
  "Congés annuels planifiés",
  "Raisons personnelles",
  "RTT conventionnel"
];

const LEAVE_TYPES: LeaveType[] = [
  LeaveType.SICK,
  LeaveType.PARENTAL,
  LeaveType.PAID,
  LeaveType.UNPAID,
  LeaveType.RTT
];




const calculateDays = (startDate: Date, endDate: Date): number => {
  const diffTime = Math.abs(endDate.getTime() - startDate.getTime());
  return Math.ceil(diffTime / (1000 * 60 * 60 * 24));
};



export const _absence: IDemandeAbsence[] = [...Array(30)].map((_, index) => {
  const submissionDate = new Date(2024, index % 12, Math.floor(Math.random() * 28) + 1);
  const startDate = new Date(submissionDate);
  startDate.setDate(startDate.getDate() + Math.floor(Math.random() * 14) + 1);
  const endDate = new Date(startDate);
  endDate.setDate(endDate.getDate() + Math.floor(Math.random() * 14) + 1);
  const processDate = new Date(submissionDate);
  processDate.setDate(processDate.getDate() + Math.floor(Math.random() * 3) + 1);
  
const requestNumber = _reuestNumber[index % _reuestNumber.length]
  const status = ['En attente', 'Approuvée', 'Refusée'][Math.floor(Math.random() * 3)] as LeaveStatus;
  
  const leaveType = LEAVE_TYPES[index % LEAVE_TYPES.length];
  

  return {
    id: (index + 1).toString(),
    requestNumber,
    submissionDate: submissionDate.toISOString().split('T')[0],
    requestType: 'Congé',
    leaveType,
    absenceType: '',
    startDate: startDate.toISOString().split('T')[0],
    endDate: endDate.toISOString().split('T')[0],
    status,
    processDate: processDate.toISOString().split('T')[0],   
    reason: _REASONS[Math.floor(Math.random() * _REASONS.length)],
    daysCount: calculateDays(startDate, endDate),
    employeeId: `EMP-${index + 1}`,
    isActive: Math.random() > 0.5,
    dateDebut: startDate.toISOString().split('T')[0],
    dateFin: endDate.toISOString().split('T')[0],
    dateSubmission: submissionDate.toISOString().split('T')[0],
    dateTraitement: processDate.toISOString().split('T')[0]
  } as IDemandeAbsence;
});

export const INITIAL_LEAVE_DATA: IDemandeAbsence = {
  id: '',
  requestNumber: '',
  requestType: 'Congé',
  leaveType: LeaveType.PAID,
  absenceType: '',
  submissionDate: new Date().toISOString().split('T')[0],
  startDate: new Date().toISOString().split('T')[0],
  endDate: new Date().toISOString().split('T')[0],
  status: 'En attente',
  processDate: new Date().toISOString().split('T')[0],
  reason: '',
  daysCount: 0,
  employeeId: '',
  isActive: true,
  dateDebut: new Date().toISOString().split('T')[0],
  dateFin: new Date().toISOString().split('T')[0],
  dateSubmission: new Date().toISOString().split('T')[0],
  dateTraitement: new Date().toISOString().split('T')[0]
};

export const ABSENCE_TABLE_COLUMNS = [
  { 
    id: 'requestNumber', 
    label: 'Numéro de demande', 
    type: 'text',
    filterable: true,
    filterType: 'text'
  },
  { 
    id: 'submissionDate', 
    label: 'Date de soumission', 
    type: 'date',
    filterable: true,
    filterType: 'date'
  },
  { 
    id: 'requestType', 
    label: 'Type de demande', 
    type: 'status',
    filterable: true,
    filterType: 'select',
    options: ['Congé', 'Absence'].map(v => ({ value: v, label: v }))
    
  },
  { 
    id: 'startDate', 
    label: 'Date de début', 
    type: 'date',
    filterable: true,
    filterType: 'date'
  },
  { 
    id: 'endDate', 
    label: 'Date de fin', 
    type: 'date',
    filterable: true,
    filterType: 'date'
  },
  { 
    id: 'daysCount', 
    label: 'Nombre de jours', 
    type: 'number',
    filterable: true,
    filterType: 'number'
  },
  { 
    id: 'status', 
    label: 'Statut', 
    type: 'status',
    filterable: true,
    filterType: 'select',
    options: ['En attente', 'Approuvée', 'Refusée'].map(v => ({ value: v, label: v }))
  },
  { 
    id: 'processDate', 
    label: 'Date de traitement', 
    type: 'date',
    filterable: true,
    filterType: 'date'
  },
  { 
    id: 'actions', 
    label: 'Actions', 
    type: 'actions',
    filterable: false
  }
];