import { IAgency } from '@/shared/types/infrastructure';
import { TableColumn } from '../types/common';
import { INITIAL_ADDRESS, MOCK_ADDRESSES } from '.';


export const DEFAULT_AGENCE_TABLE_HEAD: TableColumn[] = [
    { id: 'codeAgence', label: 'Code', align: 'left' },
    { id: 'nomAgence', label: 'Nom', align: 'left' },
    { id: 'adresse', label: 'Adresse', align: 'left' },
    { id: 'ville', label: 'Ville', align: 'left' },
    { id: 'telephone', label: 'Téléphone', align: 'left' },
    { id: 'email', label: 'Email', align: 'left' },
    { id: 'statut', label: 'Statut', align: 'left' },
];

export const INITIAL_AGENCE_DATA: IAgency = {
    id: '',
    name: '',
    adresse: INITIAL_ADDRESS,
    description: '',
    createdAt: new Date().toISOString().split('T')[0],
    updatedAt: new Date().toISOString().split('T')[0],
    departmentsNbr: 0,
    departments: [],
};

const getCurrentDate = () => new Date().toISOString().split('T')[0];

const generateDepartment = (id: string, name: string, description: string) => ({
    id,
    name,
    description,
    createdAt: getCurrentDate(),
    adresse: MOCK_ADDRESSES[Math.floor(Math.random() * MOCK_ADDRESSES.length)],
    updatedAt: getCurrentDate(),
    lotsNbr: 6
});

const generateAgency = (id: string, name: string, description: string, departmentsNbr: number) => ({
    id,
    name,
    adresse: MOCK_ADDRESSES[Math.floor(Math.random() * MOCK_ADDRESSES.length)],
    description,
    createdAt: getCurrentDate(),
    updatedAt: getCurrentDate(),
    departmentsNbr,
    departments: [
        generateDepartment("12", 'Département Achats', 'Gestion des approvisionnements'),
        generateDepartment("13", 'Département Vente', 'Gestion des ventes'),
        generateDepartment("14", 'Département Ressources Humaines', 'Gestion des ressources humaines')
    ]
});

export const _agences: IAgency[] = Array.from({ length: 13 }, (_, index) => {
    const id = (index + 1).toString();
    return generateAgency(
        id,
        `Agence ${id}`,
        `Description ${id}`,
        index + 1
    );
});